/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.debug;

import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.CollectionScriptType;
import org.eclipse.dltk.debug.core.model.ComplexScriptType;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.StringScriptType;

public class JavaScriptTypeFactory
implements IScriptTypeFactory {
    private static final String[] atomicTypes = new String[]{"number", "boolean", "date"};
    private static final String[] arrayTypes = new String[]{"javaarray", "array"};

    public IScriptType buildType(String type) {
        int i = 0;
        while (i < atomicTypes.length) {
            if (atomicTypes[i].equals(type)) {
                return new AtomicScriptType(type);
            }
            ++i;
        }
        i = 0;
        while (i < arrayTypes.length) {
            if (arrayTypes[i].equals(type)) {
                return new CollectionScriptType(type);
            }
            ++i;
        }
        if ("string".equals(type)) {
            return new StringScriptType("string");
        }
        return new ComplexScriptType(type);
    }
}

