/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import java.util.ArrayList;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.PriorityClassDLTKExtensionManager;
import org.eclipse.dltk.core.PriorityDLTKExtensionManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;

public class DLTKUILanguageManager
extends PriorityClassDLTKExtensionManager {
    private static DLTKUILanguageManager instance = new DLTKUILanguageManager();
    private static final String LANGUAGE_EXTPOINT = "org.eclipse.dltk.ui.language";

    private DLTKUILanguageManager() {
        super(LANGUAGE_EXTPOINT);
    }

    public static IDLTKUILanguageToolkit[] getLanguageToolkits() {
        PriorityDLTKExtensionManager.ElementInfo[] elementInfos = instance.getElementInfos();
        ArrayList<IDLTKUILanguageToolkit> toolkits = new ArrayList<IDLTKUILanguageToolkit>();
        int j = 0;
        while (j < elementInfos.length) {
            IDLTKUILanguageToolkit toolkit = (IDLTKUILanguageToolkit)instance.getInitObject(elementInfos[j]);
            if (toolkit != null) {
                toolkits.add(toolkit);
            }
            ++j;
        }
        return toolkits.toArray(new IDLTKUILanguageToolkit[toolkits.size()]);
    }

    public static IDLTKUILanguageToolkit getLanguageToolkit(String natureId) {
        return (IDLTKUILanguageToolkit)instance.getObject(natureId);
    }

    public static IDLTKUILanguageToolkit getLanguageToolkit(IModelElement element) {
        IDLTKLanguageToolkit coreToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
        if (coreToolkit != null) {
            return (IDLTKUILanguageToolkit)instance.getObject(coreToolkit.getNatureId());
        }
        return null;
    }

    public static ScriptUILabelProvider createLabelProvider(IModelElement element) {
        ScriptUILabelProvider provider;
        IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit(element);
        if (languageToolkit != null && (provider = languageToolkit.createScriptUILabelProvider()) != null) {
            return provider;
        }
        return new ScriptUILabelProvider();
    }

    public static ScriptUILabelProvider createLabelProvider(String nature) {
        ScriptUILabelProvider provider;
        IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit(nature);
        if (languageToolkit != null && (provider = languageToolkit.createScriptUILabelProvider()) != null) {
            return provider;
        }
        return new ScriptUILabelProvider();
    }

    public static IDLTKUILanguageToolkit getLanguageToolkitLower(String natureId) {
        return (IDLTKUILanguageToolkit)instance.getObjectLower(natureId);
    }
}

