/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.base.DLTKChange;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

abstract class SourceModuleReorgChange
extends DLTKChange {
    private String fCuHandle;
    private String fOldPackageHandle;
    private String fNewPackageHandle;
    private INewNameQuery fNewNameQuery;
    static /* synthetic */ Class class$0;

    SourceModuleReorgChange(ISourceModule cu, IScriptFolder dest, INewNameQuery newNameQuery) {
        this.fCuHandle = cu.getHandleIdentifier();
        this.fNewPackageHandle = dest.getHandleIdentifier();
        this.fNewNameQuery = newNameQuery;
        this.fOldPackageHandle = cu.getParent().getHandleIdentifier();
    }

    SourceModuleReorgChange(ISourceModule cu, IScriptFolder dest) {
        this(cu, dest, null);
    }

    SourceModuleReorgChange(String oldPackageHandle, String newPackageHandle, String cuHandle) {
        this.fOldPackageHandle = oldPackageHandle;
        this.fNewPackageHandle = newPackageHandle;
        this.fCuHandle = cuHandle;
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        pm.beginTask(this.getName(), 1);
        try {
            ISourceModule unit = this.getCu();
            ResourceMapping mapping = DLTKElementResourceMapping.create(unit);
            Change result = this.doPerformReorg((IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.markAsExecuted(unit, mapping);
            change = result;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws CoreException;

    public Object getModifiedElement() {
        return this.getCu();
    }

    ISourceModule getCu() {
        return (ISourceModule)DLTKCore.create((String)this.fCuHandle);
    }

    IScriptFolder getOldPackage() {
        return (IScriptFolder)DLTKCore.create((String)this.fOldPackageHandle);
    }

    IScriptFolder getDestinationPackage() {
        return (IScriptFolder)DLTKCore.create((String)this.fNewPackageHandle);
    }

    String getNewName() {
        if (this.fNewNameQuery == null) {
            return null;
        }
        return this.fNewNameQuery.getNewName();
    }

    static String getPackageName(IScriptFolder pack) {
        if (pack.isRootFolder()) {
            return RefactoringCoreMessages.MoveSourceModuleChange_default_package;
        }
        return pack.getElementName();
    }

    private void markAsExecuted(ISourceModule unit, ResourceMapping mapping) {
        ReorgExecutionLog log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            log.markAsProcessed((Object)unit);
            log.markAsProcessed((Object)mapping);
        }
    }
}

