/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.launchConfigurations;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.debug.ui.launchConfigurations.IMainLaunchConfigurationTabListener;
import org.eclipse.dltk.debug.ui.launchConfigurations.IMainLaunchConfigurationTabListenerManager;
import org.eclipse.dltk.debug.ui.launchConfigurations.ScriptLaunchConfigurationTab;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.preferences.FieldValidators;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class MainLaunchConfigurationTab
extends ScriptLaunchConfigurationTab
implements IMainLaunchConfigurationTabListenerManager {
    private Text fScriptText;
    private Button interactiveConsoleCheck;
    private boolean useInteractiveConsoleGroup = false;
    ListenerList listsners = new ListenerList();
    private Button fSearchButton;

    public MainLaunchConfigurationTab(String mode) {
        super(mode);
    }

    public void addListener(IMainLaunchConfigurationTabListener listener) {
        this.listsners.add((Object)listener);
    }

    public void removeListener(IMainLaunchConfigurationTabListener listener) {
        this.listsners.remove((Object)listener);
    }

    private void notifyProjectChangedListeners(IProject project) {
        Object[] listeners = this.listsners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IMainLaunchConfigurationTabListener)listeners[i]).projectChanged(project);
            ++i;
        }
    }

    protected void enableInteractiveConsoleGroup() {
        this.useInteractiveConsoleGroup = true;
    }

    protected void doInitializeForm(ILaunchConfiguration config) {
        this.updateMainModuleFromConfig(config);
        if (this.useInteractiveConsoleGroup) {
            boolean console = LaunchConfigurationUtils.getBoolean((ILaunchConfiguration)config, (String)"use_dltk_interactive_console", (boolean)false);
            this.interactiveConsoleCheck.setSelection(console);
        }
    }

    protected void createMainModuleEditor(Composite parent, String text) {
        Font font = parent.getFont();
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText(text);
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setFont(font);
        this.fScriptText = new Text((Composite)mainGroup, 2052);
        gd = new GridData(768);
        ScriptLaunchConfigurationTab.WidgetListener listener = this.getWidgetListener();
        this.fScriptText.setLayoutData((Object)gd);
        this.fScriptText.setFont(font);
        this.fScriptText.addModifyListener((ModifyListener)listener);
        this.fSearchButton = this.createPushButton((Composite)mainGroup, DLTKLaunchConfigurationsMessages.mainTab_searchButton, null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainLaunchConfigurationTab.this.handleSearchButtonSelected();
            }
        });
    }

    protected void handleSearchButtonSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(DLTKLaunchConfigurationsMessages.mainTab_searchButton_title);
        dialog.setMessage(DLTKLaunchConfigurationsMessages.mainTab_searchButton_message);
        IScriptProject proj = this.getProject();
        if (proj == null) {
            return;
        }
        dialog.setInput((Object)proj.getProject());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getProjectRelativePath().toPortableString();
            this.fScriptText.setText(arg);
        }
    }

    protected void updateMainModuleFromConfig(ILaunchConfiguration config) {
        this.fScriptText.setText(this.getMainModuleName(config));
    }

    protected void doCreateControl(Composite composite) {
        this.createMainModuleEditor(composite, DLTKLaunchConfigurationsMessages.mainTab_mainModule);
    }

    public String getName() {
        return DLTKLaunchConfigurationsMessages.mainTab_title;
    }

    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("mainScript", this.getScriptName());
        if (this.useInteractiveConsoleGroup) {
            String old;
            block6: {
                config.setAttribute("use_dltk_interactive_console", this.interactiveConsoleCheck.getSelection());
                old = null;
                try {
                    old = config.getAttribute("console_id", null);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block6;
                    e.printStackTrace();
                }
            }
            if (old == null) {
                config.setAttribute("console_id", "dltk_" + Long.toString(System.currentTimeMillis()));
            }
            if (this.interactiveConsoleCheck.getSelection()) {
                config.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            } else {
                config.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", null);
            }
        }
    }

    protected String getScriptName() {
        return this.fScriptText.getText().trim();
    }

    protected boolean validateScript() {
        URI script = this.validatAndGetScriptPath();
        IScriptProject project = this.getProject();
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
        if (script != null) {
            FieldValidators.FilePathValidator validator = new FieldValidators.FilePathValidator();
            IStatus result = validator.validate(script.getPath(), environment);
            if (!result.isOK()) {
                this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_scriptNotFound);
                return false;
            }
        } else if (this.useInteractiveConsoleGroup) {
            if (!this.interactiveConsoleCheck.getSelection()) {
                this.setErrorMessage(DLTKLaunchConfigurationsMessages.MainLaunchConfigurationTab_0);
                return false;
            }
        } else {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_scriptNotFound);
            return false;
        }
        return true;
    }

    protected URI validatAndGetScriptPath() {
        String projectName = this.getProjectName();
        IScriptProject proj = this.getScriptModel().getScriptProject(projectName);
        if (proj == null) {
            return null;
        }
        this.notifyProjectChangedListeners(proj.getProject());
        URI location = proj.getProject().getLocationURI();
        if (location == null) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_notAValidProject);
            return null;
        }
        URI script = URI.create(String.valueOf(location.toString()) + "/" + this.getScriptName());
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(script);
        if (files.length != 1) {
            return script;
        }
        IFile file = files[0];
        if (file.exists() && file.getLocationURI() != null) {
            script = file.getLocationURI();
        }
        return script;
    }

    protected boolean doCanSave() {
        return this.validateScript();
    }

    public Image getImage() {
        return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.gif");
    }

    private String getMainModuleName(ILaunchConfiguration config) {
        String[] guesses;
        String mainModuleName = LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"mainScript", (String)"");
        if ("".equals(mainModuleName) && (guesses = this.getProjectAndScriptNames()) != null) {
            super.setProjectName(guesses[0]);
            mainModuleName = guesses[1];
        }
        return mainModuleName;
    }

    protected void createCustomSections(Composite parent) {
        if (this.useInteractiveConsoleGroup) {
            Font font = parent.getFont();
            Group group = new Group(parent, 0);
            group.setText(DLTKLaunchConfigurationsMessages.MainLaunchConfigurationTab_1);
            GridData gd = new GridData(768);
            group.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            group.setFont(font);
            this.interactiveConsoleCheck = this.createCheckButton((Composite)group, DLTKLaunchConfigurationsMessages.MainLaunchConfigurationTab_2);
            this.interactiveConsoleCheck.addSelectionListener((SelectionListener)this.getWidgetListener());
        }
    }
}

