/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.tcl.internal.debug.TclDebugPreferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TclDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text debuggingEnginePath;

    protected void createDebuggingEnginePath(Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText("Path to debugging engine");
        group.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        this.debuggingEnginePath = new Text((Composite)group, 2048);
        this.debuggingEnginePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TclDebugPreferencePage.this.validteDebuggingEnginePath();
            }
        });
        GridData pathData = new GridData();
        pathData.grabExcessHorizontalSpace = true;
        pathData.horizontalAlignment = 4;
        this.debuggingEnginePath.setLayoutData(data);
        Button button = new Button((Composite)group, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(TclDebugPreferencePage.this.getShell(), 4096);
                String file = dialog.open();
                if (file != null) {
                    TclDebugPreferencePage.this.debuggingEnginePath.setText(file);
                }
            }
        });
    }

    protected GridData makeGridData() {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        return data;
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        top.setLayout((Layout)layout);
        this.createDebuggingEnginePath(top, this.makeGridData());
        this.initializeValues();
        this.validateValues();
        return top;
    }

    protected void initializeValues() {
        this.debuggingEnginePath.setText(TclDebugPreferences.getDebuggingEnginePath());
    }

    protected void validteDebuggingEnginePath() {
        String txtPath = this.debuggingEnginePath.getText().trim();
        IPath path = Path.fromOSString((String)txtPath);
        File file = path.toFile();
        if ("".equals(txtPath)) {
            this.setMessage("Empty path", 2);
            this.setValid(true);
        } else if (!file.exists()) {
            this.setMessage("File not exists", 3);
            this.setValid(false);
        } else if (!file.isFile()) {
            this.setMessage("Not a file", 3);
            this.setValid(false);
        } else {
            this.setMessage(null);
            this.setValid(true);
        }
    }

    protected void validateValues() {
        this.validteDebuggingEnginePath();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        TclDebugPreferences.setDebuggingEnginePath((String)this.debuggingEnginePath.getText());
        TclDebugPreferences.save();
        return true;
    }
}

