/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 
 *******************************************************************************/
package org.eclipse.dltk.ruby.typeinference;

public interface BuiltinTypeMethods {

	public String[] objectMethods = {
			"untaint",
			"kind_of?",
			"id",
			"method_dump",
			"instance_variable_get",
			"method",
			"nil?",
			"inspect",
			"frozen?",
			"object_id",
			"taint",
			"public_methods",
			"=~",
			"__send__",
			"to_a",
			"instance_eval",
			"extend",
			"clone",
			"protected_methods",
			"hash",
			"freeze",
			"is_a?",
			"type",
			"instance_variable_set",
			"respond_to?",
			"equal?",
			"methods",
			"instance_of?",
			"instance_variables",
			"display",
			"to_s",
			"dup",
			"private_methods",
			"==",
			"send",
			"__id__",
			"===",
			"tainted?",
			"class",
			"eql?",
			"singleton_methods"
	};
	
	public String[] stringMethods = {
			"%",
			"rindex",
			"map",
			"<<",
			"split",
			"any?",
			"sort",
			"strip",
			"size",
			"downcase",
			"min",
			"gsub!",
			"count",
			"include?",
			"succ!",
			"downcase!",
			"intern",
			"squeeze!",
			"*",
			"next",
			"find_all",
			"each",
			"rstrip!",
			"each_line",
			"+",
			"sub",
			"slice!",
			"tr",
			"replace",
			"inject",
			"reverse",
			"sort_by",
			"lstrip",
			"capitalize",
			"max",
			"chop!",
			"capitalize!",
			"scan",
			"select",
			"each_byte",
			"casecmp",
			"gsub",
			"empty?",
			"to_str",
			"partition",
			"tr_s",
			"tr!",
			"match",
			"grep",
			"rstrip",
			"to_sym",
			"next!",
			"swapcase",
			"chomp!",
			"swapcase!",
			"ljust",
			"between?",
			"reject",
			"upto",
			"hex",
			"sum",
			"reverse!",
			"chop",
			"<=>",
			"insert",
			"<",
			"delete",
			"dump",
			"member?",
			"tr_s!",
			"unpack",
			">",
			"concat",
			"succ",
			"find",
			"strip!",
			"each_with_index",
			">=",
			"to_i",
			"rjust",
			"<=",
			"index",
			"collect",
			"slice",
			"oct",
			"all?",
			"length",
			"entries",
			"chomp",
			"upcase",
			"sub!",
			"squeeze",
			"upcase!",
			"crypt",
			"delete!",
			"detect",
			"zip",
			"[]",
			"lstrip!",
			"center",
			"[]=",
			"to_f"
	};
	
	public String[] regexpMethods = {
			"source",
			"casefold?",
			"~",
			"options",
			"match",
			"kcode"
	};
	
	public String[] fixnumMethods = {
			"%",
			"<<",
			">>",
			"prec_f",
			"modulo",
			"&",
			"zero?",
			"to_int",
			"size",
			"*",
			"next",
			"+",
			"step",
			"-",
			"remainder",
			"nonzero?",
			"id2name",
			"/",
			"floor",
			"|",
			"quo",
			"~",
			"downto",
			"abs",
			"to_sym",
			"coerce",
			"^",
			"+@",
			"ceil",
			"between?",
			"-@",
			"upto",
			"prec",
			"**",
			"div",
			"singleton_method_added",
			"<=>",
			"times",
			"<",
			">",
			"succ",
			">=",
			"round",
			"to_i",
			"<=",
			"prec_i",
			"divmod",
			"chr",
			"integer?",
			"[]",
			"truncate",
			"to_f"
	};
	
	public String[] floatMethods = {
			"%",
			"prec_f",
			"modulo",
			"infinite?",
			"zero?",
			"to_int",
			"*",
			"+",
			"step",
			"-",
			"remainder",
			"finite?",
			"nonzero?",
			"/",
			"floor",
			"quo",
			"abs",
			"coerce",
			"+@",
			"ceil",
			"between?",
			"-@",
			"prec",
			"**",
			"div",
			"singleton_method_added",
			"<=>",
			"<",
			">",
			">=",
			"round",
			"to_i",
			"<=",
			"nan?",
			"prec_i",
			"divmod",
			"integer?",
			"truncate",
			"to_f"
	};
	
	public String[] arrayMethods = {
			"nitems",
			"rindex",
			"map",
			"<<",
			"any?",
			"unshift",
			"&",
			"sort",
			"join",
			"fill",
			"size",
			"min",
			"include?",
			"uniq!",
			"compact",
			"*",
			"find_all",
			"each",
			"last",
			"+",
			"slice!",
			"delete_if",
			"-",
			"replace",
			"inject",
			"each_index",
			"reverse",
			"sort!",
			"assoc",
			"sort_by",
			"to_ary",
			"max",
			"|",
			"select",
			"push",
			"empty?",
			"partition",
			"pack",
			"reverse_each",
			"rassoc",
			"grep",
			"collect!",
			"compact!",
			"at",
			"reject",
			"reject!",
			"flatten",
			"pop",
			"reverse!",
			"<=>",
			"transpose",
			"insert",
			"delete",
			"member?",
			"indexes",
			"concat",
			"map!",
			"uniq",
			"find",
			"fetch",
			"each_with_index",
			"values_at",
			"index",
			"collect",
			"slice",
			"shift",
			"all?",
			"clear",
			"length",
			"entries",
			"indices",
			"detect",
			"flatten!",
			"zip",
			"[]",
			"first",
			"[]=",
			"delete_at"
	};
	
	public String[] classMethods = {
			"include?",
			"private_instance_methods",
			"protected_method_defined?",
			"const_defined?",
			"name",
			"public_class_method",
			"autoload",
			"new",
			"instance_method",
			"constants",
			"ancestors",
			"private_class_method",
			"const_missing",
			"instance_methods",
			"superclass",
			"method_defined?",
			"const_get",
			"autoload?",
			"module_eval",
			"class_variables",
			"allocate",
			"<=>",
			"<",
			"public_instance_methods",
			"public_method_defined?",
			">",
			"included_modules",
			"const_set",
			">=",
			"<=",
			"class_eval",
			"protected_instance_methods",
			"private_method_defined?"
	};
	
}
