/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathContainerWizard;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddLibraryToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private IScriptProject fSelectedProject;
    private final IWorkbenchSite fSite;
    static /* synthetic */ Class class$0;

    public AddLibraryToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_label, DLTKPluginImages.DESC_OBJS_LIBRARY);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_tooltip);
        this.fSite = site;
    }

    public void run() {
        IBuildpathEntry[] Buildpath;
        final IScriptProject project = this.fSelectedProject;
        Shell shell = this.fSite.getShell();
        if (shell == null) {
            shell = DLTKUIPlugin.getActiveWorkbenchShell();
        }
        try {
            Buildpath = project.getRawBuildpath();
        }
        catch (ModelException e1) {
            this.showExceptionDialog((CoreException)((Object)e1));
            return;
        }
        BuildpathContainerWizard wizard = new BuildpathContainerWizard(null, project, Buildpath){

            public boolean performFinish() {
                if (super.performFinish()) {
                    IWorkspaceRunnable op = new IWorkspaceRunnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                            try {
                                1.access$0(this.this$1, monitor);
                            }
                            catch (InterruptedException e) {
                                throw new OperationCanceledException(e.getMessage());
                            }
                        }
                    };
                    try {
                        ISchedulingRule rule = null;
                        Job job = Job.getJobManager().currentJob();
                        if (job != null) {
                            rule = job.getRule();
                        }
                        WorkbenchRunnableAdapter runnable = null;
                        runnable = rule != null ? new WorkbenchRunnableAdapter(op, rule, true) : new WorkbenchRunnableAdapter(op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        this.getContainer().run(false, true, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException e) {
                        DLTKUIPlugin.log(e);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                    return true;
                }
                return false;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void finishPage(IProgressMonitor pm) throws InterruptedException {
                IBuildpathEntry[] selected = this.getNewEntries();
                if (selected == null) return;
                try {
                    try {
                        pm.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 4);
                        ArrayList<BPListElement> addedEntries = new ArrayList<BPListElement>();
                        int i = 0;
                        while (true) {
                            if (i >= selected.length) {
                                pm.worked(1);
                                if (!pm.isCanceled()) break;
                                throw new InterruptedException();
                            }
                            addedEntries.add(new BPListElement(project, selected[i].getEntryKind(), selected[i].getPath(), null, selected[i].isExported()));
                            ++i;
                        }
                        List existingEntries = BuildpathModifier.getExistingEntries(project);
                        BuildpathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        if (pm.isCanceled()) {
                            throw new InterruptedException();
                        }
                        BuildpathModifier.commitBuildPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        if (pm.isCanceled()) {
                            throw new InterruptedException();
                        }
                        ArrayList<BuildPathContainer> result = new ArrayList<BuildPathContainer>(addedEntries.size());
                        int i2 = 0;
                        while (true) {
                            if (i2 >= addedEntries.size()) {
                                AddLibraryToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                                pm.worked(1);
                            }
                            result.add(new BuildPathContainer(project, selected[i2]));
                            ++i2;
                        }
                    }
                    catch (CoreException e) {
                        AddLibraryToBuildpathAction.this.showExceptionDialog(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    pm.done();
                    throw throwable;
                }
                {
                    Object var7_11 = null;
                }
                pm.done();
            }

            static /* synthetic */ void access$0(1 var0, IProgressMonitor iProgressMonitor) throws InterruptedException {
                var0.finishPage(iProgressMonitor);
            }
        };
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    public boolean canHandle(IStructuredSelection selection) {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IScriptProject) {
            this.fSelectedProject = (IScriptProject)selection.getFirstElement();
            return true;
        }
        return false;
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddLibraryToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPart part;
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

