/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;

public abstract class ScriptDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    private static final String SUSPENDED_LABEL = "suspended";
    private static final String RUNNING_LABEL = "running";
    static /* synthetic */ Class class$0;

    public static IScriptThread getEvaluationThread(IScriptDebugTarget target) {
        IScriptThread thread = null;
        IScriptStackFrame frame = ScriptEvaluationContextManager.getEvaluationContext(null);
        if (frame != null) {
            thread = (IScriptThread)frame.getThread();
        }
        if (!(thread == null || thread.getDebugTarget().equals(target) && thread.isSuspended())) {
            thread = null;
        }
        if (thread == null) {
            try {
                IThread[] threads = target.getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].isSuspended()) {
                        thread = (IScriptThread)threads[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (DebugException e) {
                DLTKDebugUIPlugin.log(e);
            }
        }
        return thread;
    }

    protected String getDebugTargetText(IScriptDebugTarget target) {
        return target.toString();
    }

    protected String getThreadText(IScriptThread thread) {
        try {
            return String.valueOf(thread.getName()) + " (" + (thread.isSuspended() ? SUSPENDED_LABEL : RUNNING_LABEL) + ")";
        }
        catch (DebugException e) {
            DLTKDebugUIPlugin.log(e);
            return thread.toString();
        }
    }

    protected String getStackFrameText(IScriptStackFrame stackFrame) {
        try {
            return stackFrame.getName();
        }
        catch (DebugException e) {
            DLTKDebugUIPlugin.log(e);
            return stackFrame.toString();
        }
    }

    public String getVariableText(IScriptVariable variable) {
        try {
            String value;
            String name = variable.getName();
            if (!variable.hasChildren() && (value = variable.getValueString()) != null && value.length() > 0) {
                return String.valueOf(name) + " = " + value;
            }
            return name;
        }
        catch (DebugException e) {
            DLTKDebugUIPlugin.log(e);
            return variable.toString();
        }
    }

    protected String getBreakpointText(IScriptBreakpoint breakpoint) {
        try {
            StringBuffer sb = new StringBuffer();
            if (breakpoint instanceof IScriptLineBreakpoint) {
                IScriptLineBreakpoint b = (IScriptLineBreakpoint)breakpoint;
                sb.append(b.getResourceName());
                sb.append("[line: " + b.getLineNumber() + "]");
                int hitCount = b.getHitCount();
                if (hitCount != -1) {
                    sb.append(", " + hitCount + " hits");
                }
            }
            boolean cfr_ignored_0 = breakpoint instanceof IScriptWatchpoint;
            return sb.toString();
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log(e);
            return breakpoint.toString();
        }
    }

    protected String getExpressionText(IExpression expression) {
        String expressionText = expression.getExpressionText();
        try {
            IErrorReportingExpression errorExpression;
            if (expression instanceof IErrorReportingExpression && (errorExpression = (IErrorReportingExpression)expression).hasErrors()) {
                return expressionText;
            }
            IScriptValue value = (IScriptValue)expression.getValue();
            if (value != null) {
                return String.valueOf(expressionText) + " = " + value.getValueString();
            }
        }
        catch (DebugException e) {
            DLTKDebugUIPlugin.log(e);
        }
        return expressionText;
    }

    public final String getText(Object element) {
        if (element instanceof IScriptDebugTarget) {
            return this.getDebugTargetText((IScriptDebugTarget)element);
        }
        if (element instanceof IScriptBreakpoint) {
            return this.getBreakpointText((IScriptBreakpoint)element);
        }
        if (element instanceof IScriptThread) {
            return this.getThreadText((IScriptThread)element);
        }
        if (element instanceof IScriptStackFrame) {
            return this.getStackFrameText((IScriptStackFrame)element);
        }
        if (element instanceof IScriptVariable) {
            return this.getVariableText((IScriptVariable)element);
        }
        if (element instanceof IExpression) {
            return this.getExpressionText((IExpression)element);
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        try {
            listener.detailComputed(value, value.getValueString());
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    public void setAttribute(String attribute, Object value) {
    }

    protected Image getBreakpointImage(IScriptBreakpoint breakpoint) {
        return null;
    }

    protected Image getVariableImage(IScriptVariable variable) {
        return null;
    }

    protected Image getThreadImage(IScriptThread thread) {
        return null;
    }

    protected Image getStackFrameImage(IScriptStackFrame frame) {
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IScriptBreakpoint) {
            return this.getBreakpointImage((IScriptBreakpoint)element);
        }
        if (element instanceof IScriptVariable) {
            return this.getVariableImage((IScriptVariable)element);
        }
        if (element instanceof IScriptThread) {
            return this.getThreadImage((IScriptThread)element);
        }
        if (element instanceof IScriptStackFrame) {
            return this.getStackFrameImage((IScriptStackFrame)element);
        }
        return null;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof File) {
            return new ExternalFileEditorInput((File)element);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        return null;
    }

    public abstract String getEditorId(IEditorInput var1, Object var2);

    public static class ExternalFileEditorInput
    implements IPathEditorInput,
    ILocationProvider {
        private File file;

        public ExternalFileEditorInput(File file) {
            this.file = file;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.file.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.file.getAbsolutePath();
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(adapter)) {
                return this;
            }
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public IPath getPath(Object element) {
            if (element instanceof ExternalFileEditorInput) {
                ExternalFileEditorInput input = (ExternalFileEditorInput)element;
                return Path.fromOSString((String)input.file.getAbsolutePath());
            }
            return null;
        }

        public IPath getPath() {
            return Path.fromOSString((String)this.file.getAbsolutePath());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ExternalFileEditorInput) {
                ExternalFileEditorInput input = (ExternalFileEditorInput)o;
                return this.file.equals(input.file);
            }
            if (o instanceof IPathEditorInput) {
                IPathEditorInput input = (IPathEditorInput)o;
                return this.getPath().equals((Object)input.getPath());
            }
            return false;
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }
}

