/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.launching.InterpreterDefinitionsContainer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class InterpretersUpdater {
    private InterpreterDefinitionsContainer fOriginalInterpreters;

    public InterpretersUpdater() {
        this.saveCurrentAsOriginal();
    }

    private void saveCurrentAsOriginal() {
        this.fOriginalInterpreters = new InterpreterDefinitionsContainer();
        IInterpreterInstall def = null;
        String[] natures = ScriptRuntime.getInterpreterNatures();
        int i = 0;
        while (i < natures.length) {
            def = ScriptRuntime.getDefaultInterpreterInstall((String)natures[i]);
            if (def != null) {
                this.fOriginalInterpreters.setDefaultInterpreterInstallCompositeID(natures[i], ScriptRuntime.getCompositeIdFromInterpreter((IInterpreterInstall)def));
            }
            ++i;
        }
        IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes();
        int i2 = 0;
        while (i2 < types.length) {
            IInterpreterInstall[] Interpreters = types[i2].getInterpreterInstalls();
            if (Interpreters != null) {
                int j = 0;
                while (j < Interpreters.length) {
                    this.fOriginalInterpreters.addInterpreter(Interpreters[j]);
                    ++j;
                }
            }
            ++i2;
        }
    }

    public boolean updateInterpreterSettings(String nature, IInterpreterInstall[] InterpreterEnvironments, IInterpreterInstall defaultInterp) {
        InterpreterDefinitionsContainer InterpreterContainer = new InterpreterDefinitionsContainer();
        if (defaultInterp != null) {
            String defaultInterpId = ScriptRuntime.getCompositeIdFromInterpreter((IInterpreterInstall)defaultInterp);
            InterpreterContainer.setDefaultInterpreterInstallCompositeID(nature, defaultInterpId);
        } else {
            InterpreterContainer.setDefaultInterpreterInstallCompositeID(nature, null);
        }
        int i = 0;
        while (i < InterpreterEnvironments.length) {
            InterpreterContainer.addInterpreter(InterpreterEnvironments[i]);
            ++i;
        }
        List oldList = this.fOriginalInterpreters.getInterpreterList();
        String[] natures = this.fOriginalInterpreters.getInterpreterNatures();
        Iterator iter = oldList.iterator();
        while (iter.hasNext()) {
            IInterpreterInstall ii = (IInterpreterInstall)iter.next();
            if (ii.getInterpreterInstallType().getNatureId().equals(nature)) continue;
            InterpreterContainer.addInterpreter(ii);
        }
        int i2 = 0;
        while (i2 < natures.length) {
            if (!nature.equals(natures[i2])) {
                String sid = this.fOriginalInterpreters.getDefaultInterpreterInstallCompositeID(natures[i2]);
                InterpreterContainer.setDefaultInterpreterInstallCompositeID(natures[i2], sid);
            }
            ++i2;
        }
        this.saveInterpreterDefinitions(InterpreterContainer);
        this.saveCurrentAsOriginal();
        return true;
    }

    private void saveInterpreterDefinitions(final InterpreterDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(InterpretersMessages.InterpretersUpdater_0, 100);
                        String InterpreterDefXML = container.getAsXML();
                        monitor.worked(40);
                        ScriptRuntime.getPreferences().setValue(ScriptRuntime.PREF_INTERPRETER_XML, InterpreterDefXML);
                        monitor.worked(30);
                        ScriptRuntime.savePreferences();
                        monitor.worked(30);
                    }
                    catch (IOException ioe) {
                        DLTKDebugUIPlugin.log(ioe);
                    }
                    catch (ParserConfigurationException e) {
                        DLTKDebugUIPlugin.log(e);
                    }
                    catch (TransformerException e) {
                        DLTKDebugUIPlugin.log(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_8 = null;
                }
                monitor.done();
            }
        };
        try {
            DLTKDebugUIPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            DLTKDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            DLTKDebugUIPlugin.log(e);
        }
    }
}

