/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.navigator.scriptexplorer;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.tests.DLTKUITestsPlugin;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.dltk.ui.tests.navigator.scriptexplorer.MockPluginView;
import org.eclipse.dltk.ui.tests.navigator.scriptexplorer.TestDelta;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ContentProviderTests3
extends TestCase {
    private IScriptProject fJProject1;
    private IScriptProject fJProject2;
    private IProjectFragment fRoot1;
    private IScriptFolder fPack1;
    private IScriptFolder fPack2;
    private IScriptFolder fPack4;
    private IScriptFolder fPack3;
    private IWorkspace fWorkspace;
    private IWorkbench fWorkbench;
    private MockPluginView fMyPart;
    private ITreeContentProvider fProvider;
    private IProjectFragment fArchiveFragmentRoot;
    private IScriptFolder fPackJunit;
    private IScriptFolder fPackJunitSamples;
    private IScriptFolder fPackJunitSamplesMoney;
    private IScriptFolder fPack6;
    private IScriptFolder fPackJunitExtentions;
    private IScriptFolder fPackJunitFramework;
    private IScriptFolder fPackJunitRunner;
    private IScriptFolder fPackJunitTextUi;
    private IScriptFolder fPackJunitUi;
    private IScriptFolder fPackJunitTests;
    private IResource fCUIMoney;
    private IResource fCUMoney;
    private IResource fCUMoneyBag;
    private IResource fCUMoneyTest;
    private ISourceModule fCU1;
    private ISourceModule fCU2;
    private ISourceModule fCU3;
    private IFile fFile1;
    private IFile fFile2;
    private IWorkbenchPage page;
    private boolean fEnableAutoBuildAfterTesting;

    public ContentProviderTests3(String name) {
        super(name);
    }

    public void testGetChildrenProjectWithSourceFolders() throws Exception {
        Object[] expectedChildren = new Object[]{this.fRoot1, this.fFile1, this.fFile2};
        Object[] children = this.fProvider.getChildren((Object)this.fJProject2);
        ContentProviderTests3.assertTrue((String)"Wrong children found for project with folding", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrentMidLevelFragment() throws Exception {
        Object[] expectedChildren = new Object[]{this.fPack4, this.fPack6};
        Object[] children = this.fProvider.getChildren((Object)this.fPack3);
        ContentProviderTests3.assertTrue((String)"Wrong children found for ScriptFolder with folding", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragment() throws Exception {
        Object[] expectedChildren = new Object[]{};
        Object[] children = this.fProvider.getChildren((Object)this.fPack1);
        ContentProviderTests3.assertTrue((String)"Wrong children found for ScriptFolder with folding", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragmentWithCU() throws Exception {
        Object[] expectedChildren = new Object[]{this.fCU1};
        Object[] children = this.fProvider.getChildren((Object)this.fPack2);
        ContentProviderTests3.assertTrue((String)"Wrong children found for ScriptFolder with folding", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragmentInArchive() throws Exception {
        Object[] expectedChildren = new Object[]{this.fCUIMoney, this.fCUMoney, this.fCUMoneyBag, this.fCUMoneyTest};
        Object[] children = this.fProvider.getChildren((Object)this.fPackJunitSamplesMoney);
        ContentProviderTests3.assertTrue((String)"wrong children found for a bottom ScriptFolder in ProjectFragment Archive with folding", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenSource() throws Exception {
        Object[] expectedChildren = new Object[]{this.fPack1, this.fPack2, this.fPack3, this.fRoot1.getScriptFolder("")};
        Object[] children = this.fProvider.getChildren((Object)this.fRoot1);
        ContentProviderTests3.assertTrue((String)"Wrong children found for ProjectFragment with folding", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenArchive() {
        Object[] expectedChildren = new Object[]{this.fPackJunit, this.fArchiveFragmentRoot.getScriptFolder("")};
        Object[] children = this.fProvider.getChildren((Object)this.fArchiveFragmentRoot);
        ContentProviderTests3.assertTrue((String)"Wrong child found for ProjectFragment Archive with folding", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetParentArchive() throws Exception {
        Object parent = this.fProvider.getParent((Object)this.fArchiveFragmentRoot);
        ContentProviderTests3.assertTrue((String)"Wrong parent found for ProjectFragment Archive with folding", (parent == this.fJProject1 ? 1 : 0) != 0);
    }

    public void testGetParentTopLevelFragmentInArchive() throws Exception {
        IScriptFolder expectedParent = this.fPackJunit;
        Object parent = this.fProvider.getParent((Object)this.fPackJunitSamples);
        ContentProviderTests3.assertTrue((String)"Wrong parent found for a top level ScriptFolder in an Archive with folding", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentTopLevelFragment() throws Exception {
        IProjectFragment expectedParent = this.fRoot1;
        Object parent = this.fProvider.getParent((Object)this.fPack3);
        ContentProviderTests3.assertTrue((String)"Wrong parent found for a top level ScriptFolder with folding", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentFoldedBottomFragment() throws Exception {
        IProjectFragment expectedParent = this.fRoot1;
        Object parent = this.fProvider.getParent((Object)this.fPack3);
        ContentProviderTests3.assertTrue((String)"Wrong parent found for a top level ScriptFolder with folding", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentMidLevelFragment() throws Exception {
        IScriptFolder expectedParent = this.fPack3;
        Object parent = this.fProvider.getParent((Object)this.fPack4);
        ContentProviderTests3.assertTrue((String)"Wrong parent found for a NON top level ScriptFolder with folding", (boolean)expectedParent.equals(parent));
    }

    public void testDeleteBottomLevelFragmentFolding() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createDelta(this.fPack4, 2);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
            ContentProviderTests3.assertTrue((String)"Refresh happened", (boolean)this.fMyPart.hasRefreshHappened());
        }
        ContentProviderTests3.assertTrue((String)"Correct Refresh", (boolean)this.fMyPart.wasObjectRefreshed(this.fRoot1));
        ContentProviderTests3.assertTrue((String)"Single refresh", (this.fMyPart.getRefreshedObject().size() == 1 ? 1 : 0) != 0);
    }

    public void testAddBottomLevelFragmentFolding() throws Exception {
        IScriptFolder test = this.fRoot1.createScriptFolder("test", true, null);
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createDelta(test, 1);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests3.assertTrue((String)"Refresh happened", (boolean)this.fMyPart.hasRefreshHappened());
        ContentProviderTests3.assertTrue((String)"Correct Refresh", (boolean)this.fMyPart.wasObjectRefreshed(this.fRoot1));
        ContentProviderTests3.assertTrue((String)"Single refreshe", (this.fMyPart.getRefreshedObject().size() == 1 ? 1 : 0) != 0);
    }

    public void testChangedTopLevelScriptFolderFolding() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createDelta(this.fPack3, 4);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests3.assertEquals((String)"No refreshs", (int)0, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testChangeBottomLevelScriptFolderFolding() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createDelta(this.fPack6, 4);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests3.assertEquals((String)"No refreshs", (int)0, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testRemoveCUsFromScriptFolder() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createCUDelta(new ISourceModule[]{this.fCU2, this.fCU3}, this.fPack6, 2);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests3.assertEquals((String)"One refresh", (int)1, (int)this.fMyPart.getRefreshedObject().size());
    }

    public void testRemoveCUFromScriptFolder() throws Exception {
        IElementChangedListener listener = (IElementChangedListener)this.fProvider;
        IModelElementDelta delta = TestDelta.createCUDelta(new ISourceModule[]{this.fCU2}, this.fPack6, 2);
        listener.elementChanged(new ElementChangedEvent(delta, 1));
        while (this.fMyPart.getTreeViewer().getControl().getDisplay().readAndDispatch()) {
        }
        ContentProviderTests3.assertTrue((String)"Remove happened", (boolean)this.fMyPart.hasRemoveHappened());
        ContentProviderTests3.assertTrue((String)"Correct refresh", (boolean)this.fMyPart.getRemovedObject().contains(this.fCU2));
        ContentProviderTests3.assertEquals((String)"No refreshes", (int)0, (int)this.fMyPart.getRefreshedObject().size());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fWorkspace = ResourcesPlugin.getWorkspace();
        ContentProviderTests3.assertNotNull((Object)this.fWorkspace);
        IWorkspaceDescription workspaceDesc = this.fWorkspace.getDescription();
        this.fEnableAutoBuildAfterTesting = workspaceDesc.isAutoBuilding();
        if (this.fEnableAutoBuildAfterTesting) {
            ScriptProjectHelper.setAutoBuilding(false);
        }
        this.fJProject1 = ScriptProjectHelper.createScriptProject("TestProject1");
        this.fJProject2 = ScriptProjectHelper.createScriptProject("TestProject2");
        ContentProviderTests3.assertNotNull((String)"project1 null", (Object)this.fJProject1);
        ContentProviderTests3.assertNotNull((String)"project2 null", (Object)this.fJProject2);
        Object[] resource = this.fJProject2.getForeignResources();
        int i = 0;
        while (i < resource.length) {
            Object object = resource[i];
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                if (".buildpath".equals(file.getName())) {
                    this.fFile1 = file;
                } else if (".project".equals(file.getName())) {
                    this.fFile2 = file;
                }
            }
            ++i;
        }
        ContentProviderTests3.assertNotNull((Object)this.fFile1);
        ContentProviderTests3.assertNotNull((Object)this.fFile2);
        File junitSrcArchive = DLTKUITestsPlugin.getDefault().getFileInPlugin(ScriptProjectHelper.JUNIT_SRC_381);
        ContentProviderTests3.assertTrue((String)"junit src not found", (junitSrcArchive != null && junitSrcArchive.exists() ? 1 : 0) != 0);
        this.fArchiveFragmentRoot = ScriptProjectHelper.addSourceContainerWithImport(this.fJProject1, "src", junitSrcArchive, "ISO-8859-1");
        this.fPackJunit = this.fArchiveFragmentRoot.getScriptFolder("junit");
        this.fPackJunitSamples = this.fArchiveFragmentRoot.getScriptFolder("junit/samples");
        this.fPackJunitSamplesMoney = this.fArchiveFragmentRoot.getScriptFolder("junit/samples/money");
        this.fPackJunitExtentions = this.fArchiveFragmentRoot.getScriptFolder("junit/extensions");
        this.fPackJunitFramework = this.fArchiveFragmentRoot.getScriptFolder("junit/framework");
        this.fPackJunitRunner = this.fArchiveFragmentRoot.getScriptFolder("junit/runner");
        this.fPackJunitTests = this.fArchiveFragmentRoot.getScriptFolder("junit/tests");
        this.fPackJunitTextUi = this.fArchiveFragmentRoot.getScriptFolder("junit/textui");
        this.fPackJunitUi = this.fArchiveFragmentRoot.getScriptFolder("junit/ui");
        ContentProviderTests3.assertNotNull((String)"creating fPackJunit", (Object)this.fPackJunit);
        ContentProviderTests3.assertNotNull((String)"creating fPackJunitSamples", (Object)this.fPackJunitSamples);
        ContentProviderTests3.assertNotNull((String)"creating fPackJunitSamplesMoney", (Object)this.fPackJunitSamplesMoney);
        ContentProviderTests3.assertNotNull((String)"", (Object)this.fPackJunitExtentions);
        ContentProviderTests3.assertNotNull((String)"", (Object)this.fPackJunitFramework);
        ContentProviderTests3.assertNotNull((String)"", (Object)this.fPackJunitRunner);
        ContentProviderTests3.assertNotNull((String)"", (Object)this.fPackJunitTests);
        ContentProviderTests3.assertNotNull((String)"", (Object)this.fPackJunitTextUi);
        ContentProviderTests3.assertNotNull((String)"", (Object)this.fPackJunitUi);
        this.fCUIMoney = this.fPackJunitSamplesMoney.getSourceModule("IMoney.java").getResource();
        this.fCUMoney = this.fPackJunitSamplesMoney.getSourceModule("Money.java").getResource();
        this.fCUMoneyBag = this.fPackJunitSamplesMoney.getSourceModule("MoneyBag.java").getResource();
        this.fCUMoneyTest = this.fPackJunitSamplesMoney.getSourceModule("MoneyTest.java").getResource();
        File mylibArchive = DLTKUITestsPlugin.getDefault().getFileInPlugin(ScriptProjectHelper.MYLIB);
        ContentProviderTests3.assertTrue((String)"lib not found", (mylibArchive != null && mylibArchive.exists() ? 1 : 0) != 0);
        ScriptProjectHelper.addLibraryWithImport(this.fJProject1, Path.fromOSString((String)mylibArchive.getPath()));
        this.fRoot1 = ScriptProjectHelper.addSourceContainer(this.fJProject2, "src1");
        this.fPack1 = this.fRoot1.createScriptFolder("pack1", true, null);
        this.fPack2 = this.fRoot1.createScriptFolder("pack2", true, null);
        this.fPack3 = this.fRoot1.createScriptFolder("pack3", true, null);
        this.fPack4 = this.fRoot1.createScriptFolder("pack3/pack4", true, null);
        this.fRoot1.createScriptFolder("pack3/pack5", true, null);
        this.fPack6 = this.fRoot1.createScriptFolder("pack3/pack5/pack6", true, null);
        this.fCU1 = this.fPack2.createSourceModule("Object.txt", "", true, null);
        this.fCU2 = this.fPack6.createSourceModule("Object.txt", "", true, null);
        this.fCU3 = this.fPack6.createSourceModule("Jen.txt", "", true, null);
        this.setUpMockView();
    }

    public void setUpMockView() throws Exception {
        this.fWorkbench = PlatformUI.getWorkbench();
        ContentProviderTests3.assertNotNull((Object)this.fWorkbench);
        this.page = this.fWorkbench.getActiveWorkbenchWindow().getActivePage();
        ContentProviderTests3.assertNotNull((Object)this.page);
        MockPluginView myPart = new MockPluginView();
        ContentProviderTests3.assertNotNull((Object)((Object)myPart));
        myPart = this.page.showView("org.eclipse.dltk.ui.tests.packageview.MockPluginView");
        if (myPart instanceof MockPluginView) {
            this.fMyPart = myPart;
            this.fMyPart.setFolding(true);
            this.fMyPart.fRefreshedObjects.clear();
            this.fProvider = (ITreeContentProvider)this.fMyPart.getTreeViewer().getContentProvider();
        } else {
            ContentProviderTests3.assertTrue((String)"Unable to get view", (boolean)false);
        }
        ContentProviderTests3.assertNotNull((Object)this.fProvider);
    }

    protected void tearDown() throws Exception {
        this.fArchiveFragmentRoot.close();
        ScriptProjectHelper.delete((IModelElement)this.fJProject1);
        ScriptProjectHelper.delete((IModelElement)this.fJProject2);
        this.page.hideView((IViewPart)this.fMyPart);
        if (this.fEnableAutoBuildAfterTesting) {
            ScriptProjectHelper.setAutoBuilding(true);
        }
        super.tearDown();
    }

    private boolean compareArrays(Object[] children, Object[] expectedChildren) {
        if (children.length != expectedChildren.length) {
            return false;
        }
        int i = 0;
        while (i < children.length) {
            IResource res;
            IModelElement el;
            Object child = children[i];
            if (child instanceof IModelElement ? !this.contains(el = (IModelElement)child, expectedChildren) : child instanceof IResource && !this.contains(res = (IResource)child, expectedChildren)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean contains(IResource res, Object[] expectedChildren) {
        int i = 0;
        while (i < expectedChildren.length) {
            IResource expres;
            Object object = expectedChildren[i];
            if (object instanceof IResource && (expres = (IResource)object).equals((Object)res)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(IModelElement fragment, Object[] expectedChildren) {
        int i = 0;
        while (i < expectedChildren.length) {
            IModelElement expfrag;
            Object object = expectedChildren[i];
            if (object instanceof IModelElement && (expfrag = (IModelElement)object).equals(fragment)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

