/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ManPageFolder {
    private String path;
    private HashMap pages = new HashMap();

    public ManPageFolder(String path) {
        this.path = path;
    }

    public void addPage(String keyword, String file) {
        this.pages.put(keyword, file);
    }

    public boolean verify() {
        if (this.path == null) {
            return false;
        }
        File file = new File(this.path);
        return file.exists() && file.isDirectory();
    }

    public String getPath() {
        return this.path;
    }

    public HashMap getPages() {
        return this.pages;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ManPageFolder)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ManPageFolder f = (ManPageFolder)obj;
        if (!f.path.equals(this.path)) {
            return false;
        }
        return f.pages.equals(this.pages);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List readXML(String data) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data.getBytes());
        Element config = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                config = parser.parse(new InputSource(stream)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException("Bad XML format");
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ((InputStream)stream).close();
                throw new IOException("Bad XML format");
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            ((InputStream)stream).close();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        ((InputStream)stream).close();
        if (!config.getNodeName().equalsIgnoreCase("manPages")) {
            throw new RuntimeException("Bad top level node");
        }
        ArrayList<ManPageFolder> folders = new ArrayList<ManPageFolder>();
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && node.getNodeName().equalsIgnoreCase("location")) {
                Element location = (Element)node;
                String path = location.getAttribute("path");
                ManPageFolder folder = new ManPageFolder(path);
                NodeList locationChilds = location.getChildNodes();
                int pages = locationChilds.getLength();
                int j = 0;
                while (true) {
                    if (j >= pages) {
                        folders.add(folder);
                        break;
                    }
                    node = locationChilds.item(j);
                    type = node.getNodeType();
                    if (type == 1 && node.getNodeName().equalsIgnoreCase("page")) {
                        Element word = (Element)node;
                        String kw = word.getAttribute("keyword");
                        String file = word.getAttribute("file");
                        folder.addPage(kw, file);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return folders;
    }
}

