/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.internal.parsers.raw.BracesSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.CommandSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.QuotesSubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclScript;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclWord;

public class TclSourceParser
implements ISourceParser {
    private int currentPosition = 0;

    public ModuleDeclaration parse(char[] fileName, char[] content0, IProblemReporter reporter) {
        TclScript script;
        String content = new String(content0);
        try {
            script = SimpleTclParser.parse(content);
        }
        catch (TclParseException e) {
            if (DLTKCore.DEBUG_PARSER) {
                e.printStackTrace();
            }
            return null;
        }
        TclModuleDeclaration moduleDeclaration = new TclModuleDeclaration(content.length());
        ArrayList<TclStatement> statements = new ArrayList<TclStatement>();
        List commands = script.getCommands();
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            TclCommand c = (TclCommand)iter.next();
            ArrayList<Object> exprs = new ArrayList<Object>();
            List words = c.getWords();
            Iterator iterator = words.iterator();
            while (iterator.hasNext()) {
                TclElement bs;
                TclWord word = (TclWord)iterator.next();
                String wordText = content.substring(word.getStart(), word.getEnd() + 1);
                Object o = word.getContents().get(0);
                if (o instanceof QuotesSubstitution) {
                    QuotesSubstitution qs = (QuotesSubstitution)o;
                    exprs.add(new StringLiteral(this.currentPosition + qs.getStart(), this.currentPosition + qs.getEnd() + 1, wordText));
                    continue;
                }
                if (o instanceof BracesSubstitution) {
                    bs = (BracesSubstitution)o;
                    TclBlockExpression tclBlockExpression = new TclBlockExpression(this.currentPosition + bs.getStart(), this.currentPosition + bs.getEnd() + 1, wordText);
                    tclBlockExpression.setFilename(fileName);
                    exprs.add((Object)tclBlockExpression);
                    continue;
                }
                if (o instanceof CommandSubstitution && word.getContents().size() == 1) {
                    bs = (CommandSubstitution)o;
                    exprs.add((Object)new TclExecuteExpression(this.currentPosition + bs.getStart(), this.currentPosition + bs.getEnd() + 1, wordText));
                    continue;
                }
                exprs.add(new SimpleReference(this.currentPosition + word.getStart(), this.currentPosition + word.getEnd() + 1, wordText));
            }
            TclStatement st = new TclStatement(exprs);
            statements.add(st);
        }
        Iterator i = statements.iterator();
        while (i.hasNext()) {
            moduleDeclaration.addStatement((Statement)i.next());
        }
        return moduleDeclaration;
    }

    public void setCurrentPosition(int startFrom) {
        this.currentPosition = startFrom;
    }
}

