/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.AliasedRubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinAlias;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;
import org.eclipse.dltk.ruby.internal.parser.mixin.SuperclassReferenceInfo;
import org.eclipse.dltk.ruby.typeinference.IMixinSearchRequestor;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class RubyMixinClass
implements IRubyMixinElement {
    private final String key;
    protected final RubyMixinModel model;
    private final boolean module;

    public RubyMixinClass(RubyMixinModel model, String key, boolean module) {
        this.model = model;
        this.key = key;
        this.module = module;
    }

    public String getKey() {
        return this.key;
    }

    public RubyMixinClass getInstanceClass() {
        if (!this.isMeta()) {
            return this;
        }
        String newkey = String.valueOf(this.key) + "%";
        IRubyMixinElement r = this.model.createRubyElement(newkey);
        if (r instanceof RubyMixinClass) {
            return (RubyMixinClass)r;
        }
        return null;
    }

    public RubyMixinClass getMetaclass() {
        if (this.isMeta()) {
            return this;
        }
        String metakey = this.key.substring(0, this.key.indexOf("%"));
        IRubyMixinElement r = this.model.createRubyElement(metakey);
        if (r instanceof RubyMixinClass) {
            return (RubyMixinClass)r;
        }
        return null;
    }

    public boolean isMeta() {
        return !this.key.endsWith("%") && !this.key.endsWith("%v");
    }

    public String getName() {
        String name = this.key.substring(this.key.lastIndexOf("{"));
        int pos = name.indexOf("%");
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public IType[] getSourceTypes() {
        ArrayList<Object> result = new ArrayList<Object>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        Object[] allObjects = mixinElement.getAllObjects();
        int i = 0;
        while (i < allObjects.length) {
            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
            if (info != null && (info.getKind() == 0 || info.getKind() == 1)) {
                result.add(info.getObject());
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    public RubyMixinClass getSuperclass() {
        if (this.module) {
            return null;
        }
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        if (mixinElement == null) {
            return null;
        }
        Object[] allObjects = mixinElement.getAllObjects();
        int i = 0;
        while (i < allObjects.length) {
            SuperclassReferenceInfo sinfo;
            BasicContext c;
            ExpressionTypeGoal g;
            DLTKTypeInferenceEngine engine;
            IEvaluatedType type2;
            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
            if (info != null && info.getKind() == 6 && (type2 = (engine = new DLTKTypeInferenceEngine()).evaluateType((AbstractTypeGoal)(g = new ExpressionTypeGoal((IContext)(c = new BasicContext((sinfo = (SuperclassReferenceInfo)info.getObject()).getModule(), sinfo.getDecl())), sinfo.getNode())), 500)) instanceof RubyClassType) {
                RubyClassType rubyClassType = (RubyClassType)type2;
                String key = rubyClassType.getModelKey();
                if (!this.isMeta()) {
                    key = String.valueOf(key) + "%";
                }
                return (RubyMixinClass)this.model.createRubyElement(key);
            }
            ++i;
        }
        String key = this.isMeta() ? "Class%" : "Object";
        if (!this.isMeta()) {
            key = String.valueOf(key) + "%";
        }
        RubyMixinClass s = (RubyMixinClass)this.model.createRubyElement(key);
        return s;
    }

    public RubyMixinClass[] getIncluded() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        HashSet<String> names = new HashSet<String>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        if (mixinElement == null) {
            return new RubyMixinClass[0];
        }
        Object[] allObjects = mixinElement.getAllObjects();
        int i = 0;
        while (i < allObjects.length) {
            String inclKey;
            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
            if (info != null && info.getKind() == 4 && !names.contains(inclKey = (String)info.getObject())) {
                IRubyMixinElement element;
                names.add(inclKey);
                if (!inclKey.endsWith("%")) {
                    inclKey = String.valueOf(inclKey) + "%";
                }
                if ((element = this.model.createRubyElement(inclKey)) instanceof RubyMixinClass) {
                    result.add(element);
                }
            }
            ++i;
        }
        return result.toArray(new RubyMixinClass[result.size()]);
    }

    public void findMethods(String prefix, boolean includeTopLevel, IMixinSearchRequestor requestor) {
        RubyMixinMethod[] methods;
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        if (mixinElement == null) {
            return;
        }
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getLastKeySegment().startsWith(prefix)) {
                RubyMixinAlias alias;
                IRubyMixinElement oldElement;
                IRubyMixinElement element = this.model.createRubyElement(children[i]);
                if (element instanceof RubyMixinMethod) {
                    requestor.acceptResult(element);
                }
                if (element instanceof RubyMixinAlias && (oldElement = (alias = (RubyMixinAlias)element).getOldElement()) instanceof RubyMixinMethod) {
                    AliasedRubyMixinMethod a = new AliasedRubyMixinMethod(this.model, alias);
                    requestor.acceptResult(a);
                }
            }
            ++i;
        }
        RubyMixinClass[] included = this.getIncluded();
        int i2 = 0;
        while (i2 < included.length) {
            methods = included[i2].findMethods(prefix, includeTopLevel);
            int j = 0;
            while (j < methods.length) {
                requestor.acceptResult(methods[j]);
                ++j;
            }
            ++i2;
        }
        if (!this.key.endsWith("%v")) {
            RubyMixinClass superclass = this.getSuperclass();
            if (superclass != null && !superclass.getKey().equals(this.key)) {
                methods = superclass.findMethods(prefix, includeTopLevel);
                int j = 0;
                while (j < methods.length) {
                    requestor.acceptResult(methods[j]);
                    ++j;
                }
            }
        } else {
            String stdKey = this.key.substring(0, this.key.length() - "%v".length());
            IRubyMixinElement realElement = this.model.createRubyElement(stdKey);
            if (realElement instanceof RubyMixinClass) {
                RubyMixinClass rubyMixinClass = (RubyMixinClass)realElement;
                rubyMixinClass.findMethods(prefix, includeTopLevel, requestor);
            }
        }
    }

    public RubyMixinMethod[] findMethods(String prefix, boolean includeTopLevel) {
        final ArrayList result = new ArrayList();
        final HashSet names = new HashSet();
        this.findMethods(prefix, includeTopLevel, new IMixinSearchRequestor(){

            public void acceptResult(IRubyMixinElement element) {
                RubyMixinMethod method;
                if (element instanceof RubyMixinMethod && !names.contains((method = (RubyMixinMethod)element).getName())) {
                    result.add(method);
                    names.add(method.getName());
                }
            }
        });
        return result.toArray(new RubyMixinMethod[result.size()]);
    }

    public RubyMixinMethod getMethod(String name) {
        String possibleKey = String.valueOf(this.key) + "{" + name;
        IMixinElement mixinElement = this.model.getRawModel().get(possibleKey);
        if (mixinElement != null) {
            RubyMixinAlias alias;
            IRubyMixinElement oldElement;
            IRubyMixinElement element = this.model.createRubyElement(mixinElement);
            if (element instanceof RubyMixinMethod) {
                return (RubyMixinMethod)element;
            }
            if (element instanceof RubyMixinAlias && (oldElement = (alias = (RubyMixinAlias)element).getOldElement()) instanceof RubyMixinMethod) {
                return new AliasedRubyMixinMethod(this.model, alias);
            }
        }
        RubyMixinClass[] included = this.getIncluded();
        int i = 0;
        while (i < included.length) {
            RubyMixinMethod method = included[i].getMethod(name);
            if (method != null) {
                return method;
            }
            ++i;
        }
        RubyMixinClass superclass = this.getSuperclass();
        if (superclass != null) {
            if (superclass.getKey().equals(this.key)) {
                return null;
            }
            return superclass.getMethod(name);
        }
        return null;
    }

    public RubyMixinClass[] getClasses() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            IRubyMixinElement element = this.model.createRubyElement(children[i]);
            if (element instanceof RubyMixinClass) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new RubyMixinClass[result.size()]);
    }

    public RubyMixinVariable[] getFields() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            IRubyMixinElement element = this.model.createRubyElement(children[i]);
            if (element instanceof RubyMixinVariable) {
                result.add(element);
            }
            ++i;
        }
        RubyMixinClass superclass = this.getSuperclass();
        if (superclass != null && superclass.key != "Object" && superclass.key != "Object%") {
            if (superclass.getKey().equals(this.key)) {
                return null;
            }
            RubyMixinVariable[] superFields = superclass.getFields();
            result.addAll(Arrays.asList(superFields));
        }
        return result.toArray(new RubyMixinVariable[result.size()]);
    }
}

