/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.IWorkingCopyProvider;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StandardModelElementContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardModelElementContentProvider() {
        this(false);
    }

    public StandardModelElementContentProvider(boolean provideMembers) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideMembers;
    }

    public boolean getProvideMembers(Object element) {
        IDLTKUILanguageToolkit languageToolkit;
        if (element instanceof ISourceModule && (languageToolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)((ISourceModule)element))) != null) {
            return this.fProvideMembers && languageToolkit.getProvideMembers((ISourceModule)element);
        }
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof IScriptModel) {
                return this.getScriptProjects((IScriptModel)element);
            }
            if (element instanceof IScriptProject) {
                return this.getProjectFragments((IScriptProject)element);
            }
            if (element instanceof IProjectFragment) {
                return this.getScriptFolders((IProjectFragment)element);
            }
            if (element instanceof IScriptFolder) {
                return this.getFolderContents((IScriptFolder)element);
            }
            if (element instanceof IFolder) {
                return this.getResources((IFolder)element);
            }
            if (this.getProvideMembers(element) && element instanceof ISourceReference && element instanceof IParent) {
                return ((IParent)element).getChildren();
            }
        }
        catch (ModelException modelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        Object[] children;
        IScriptProject jp;
        if (this.getProvideMembers(element)) {
            if (element instanceof ISourceModule) {
                return true;
            }
        } else if (element instanceof ISourceModule || element instanceof IFile) {
            return false;
        }
        if (element instanceof IScriptProject && !(jp = (IScriptProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (ModelException modelException) {
                return true;
            }
        }
        return (children = this.getChildren(element)) != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    private Object[] getScriptFolders(IProjectFragment root) throws ModelException {
        Object[] fragments = root.getChildren();
        if (this.isProjectProjectFragment(root)) {
            return fragments;
        }
        ArrayList<Object> newFragments = new ArrayList<Object>();
        int i = 0;
        while (i < fragments.length) {
            IScriptFolder scriptFolder;
            if (fragments[i] instanceof IScriptFolder && (scriptFolder = (IScriptFolder)fragments[i]).isRootFolder()) {
                IModelElement[] children = scriptFolder.getChildren();
                int j = 0;
                while (j < children.length) {
                    newFragments.add(children[j]);
                    ++j;
                }
            } else {
                newFragments.add(fragments[i]);
            }
            ++i;
        }
        fragments = newFragments.toArray(new IModelElement[newFragments.size()]);
        Object[] nonScriptResources = root.getForeignResources();
        if (nonScriptResources == null) {
            return fragments;
        }
        return StandardModelElementContentProvider.concatenate(fragments, nonScriptResources);
    }

    protected Object[] getProjectFragments(IScriptProject project) throws ModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IProjectFragment[] roots = project.getProjectFragments();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            if (this.isProjectProjectFragment(root)) {
                IModelElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    if (children[k] instanceof IScriptFolder) {
                        IScriptFolder folder = (IScriptFolder)children[k];
                        if (folder.isRootFolder()) {
                            IModelElement[] rootChildren = folder.getChildren();
                            int j = 0;
                            while (j < rootChildren.length) {
                                list.add(rootChildren[j]);
                                ++j;
                            }
                        } else {
                            list.add(children[k]);
                        }
                    }
                    ++k;
                }
            } else if (this.hasChildren(root)) {
                list.add(root);
            }
            ++i;
        }
        return StandardModelElementContentProvider.concatenate(list.toArray(), project.getForeignResources());
    }

    protected Object[] getScriptProjects(IScriptModel model) throws ModelException {
        return model.getScriptProjects();
    }

    private Object[] getFolderContents(IScriptFolder fragment) throws ModelException {
        return StandardModelElementContentProvider.concatenate(fragment.getSourceModules(), fragment.getForeignResources());
    }

    private Object[] getResources(IFolder folder) {
        try {
            Object[] members = folder.members();
            IScriptProject scriptProject = DLTKCore.create((IProject)folder.getProject());
            if (scriptProject == null || !scriptProject.exists()) {
                return members;
            }
            boolean isFolderOnBuildpath = scriptProject.isOnBuildpath((IResource)folder);
            ArrayList<Object> nonScriptResources = new ArrayList<Object>();
            int i = 0;
            while (i < members.length) {
                Object member = members[i];
                if (isFolderOnBuildpath) {
                    if (scriptProject.findProjectFragment(member.getFullPath()) == null) {
                        nonScriptResources.add(member);
                    }
                } else if (!scriptProject.isOnBuildpath((IResource)member)) {
                    nonScriptResources.add(member);
                }
                ++i;
            }
            return nonScriptResources.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected boolean isBuildPathChange(IModelElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected Object skipProjectProjectFragmment(IProjectFragment root) {
        if (this.isProjectProjectFragment(root)) {
            return root.getParent();
        }
        return root;
    }

    protected boolean isScriptFolderEmpty(IModelElement element) throws ModelException {
        IScriptFolder fragment;
        return element instanceof IScriptFolder && (fragment = (IScriptFolder)element).exists() && !fragment.hasChildren() && fragment.getForeignResources().length <= 0 && fragment.hasSubfolders();
    }

    protected boolean isProjectProjectFragment(IProjectFragment root) {
        IScriptProject scriptProject = root.getScriptProject();
        return scriptProject != null && scriptProject.getPath().equals((Object)root.getPath());
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IModelElement) {
            return ((IModelElement)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IModelElement jParent = DLTKCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IModelElement) {
            IModelElement parent = ((IModelElement)element).getParent();
            if (element instanceof IScriptFolder) {
                return this.skipProjectProjectFragmment((IProjectFragment)parent);
            }
            return parent;
        }
        return null;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    protected Object skipProjectProjectFragment(IProjectFragment root) {
        if (this.isProjectScriptFolder(root)) {
            return root.getParent();
        }
        return root;
    }

    protected boolean isProjectScriptFolder(IProjectFragment root) {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }
}

