/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.mixin;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinParser;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.mixin.IInternalMixinElement;
import org.eclipse.dltk.internal.core.mixin.MixinCache;
import org.eclipse.dltk.internal.core.mixin.MixinManager;

public class MixinModel {
    public static final String SEPARATOR = "{";
    private MixinCache cache = null;
    private Map elementToMixinCache = new HashMap();
    private IDLTKLanguageToolkit toolkit = null;
    private MixinRequestor mixinRequestor = new MixinRequestor();
    private ISourceModule currentModule;
    private Set modulesToReparse = new HashSet();
    public long removes = 1L;
    double ratio = 2000.0;
    private Set existKeysCache = new HashSet();
    private Set notExistKeysCache = new HashSet();
    private IMixinChangedListener changedListener = new IMixinChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            IModelElementDelta delta = event.getDelta();
            this.processDelta(delta);
        }

        private void processDelta(IModelElementDelta delta) {
            IModelElement element = delta.getElement();
            if (delta.getKind() == 2 || delta.getKind() == 4 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 4) != 0) {
                if (element.getElementType() != 5 && element.getElementType() != 3 && element.getElementType() != 4 && element.getElementType() != 1 && element.getElementType() != 2) {
                    ISourceModule module = (ISourceModule)element.getAncestor(5);
                    MixinModel.this.remove(module);
                }
                if (element.getElementType() == 5) {
                    MixinModel.this.remove((ISourceModule)element);
                }
            }
            if (delta.getKind() == 4 && (delta.getFlags() & 0x80) != 0) {
                MixinModel.this.cache.flush();
            }
            if (delta.getKind() == 4 && (delta.getFlags() & 0x40) != 0) {
                MixinModel.this.notExistKeysCache.clear();
            }
            if (delta.getKind() == 1) {
                if (element.getElementType() == 5 && !MixinModel.this.modulesToReparse.contains(element)) {
                    MixinModel.this.modulesToReparse.add(element);
                    MixinModel.this.reportModule((ISourceModule)element);
                }
                MixinModel.this.notExistKeysCache.clear();
            }
            if ((delta.getFlags() & 8) != 0) {
                IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
                int i = 0;
                while (i < affectedChildren.length) {
                    IModelElementDelta child = affectedChildren[i];
                    this.processDelta(child);
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            int eventType = event.getType();
            IResource resource = event.getResource();
            switch (eventType) {
                case 4: {
                    if (resource.getType() == 4 && DLTKLanguageManager.hasScriptNature((IProject)resource)) {
                        ArrayList<ISourceModule> toRemove = new ArrayList<ISourceModule>();
                        Map map = MixinModel.this.elementToMixinCache;
                        synchronized (map) {
                            IProject project = (IProject)resource;
                            Iterator iterator = MixinModel.this.elementToMixinCache.keySet().iterator();
                            while (iterator.hasNext()) {
                                ISourceModule module = (ISourceModule)iterator.next();
                                IScriptProject scriptProject = module.getScriptProject();
                                if (scriptProject != null) {
                                    IProject prj = scriptProject.getProject();
                                    if ((prj == null || !prj.equals((Object)project)) && prj != null) continue;
                                    toRemove.add(module);
                                    continue;
                                }
                                toRemove.add(module);
                            }
                        }
                        Iterator iterator = toRemove.iterator();
                        while (iterator.hasNext()) {
                            ISourceModule module = (ISourceModule)iterator.next();
                            MixinModel.this.remove(module);
                        }
                    }
                    return;
                }
            }
        }
    };
    private final ListenerList mixinObjectInitializeListeners = new ListenerList();

    public MixinModel(IDLTKLanguageToolkit toolkit) {
        this.toolkit = toolkit;
        this.cache = new MixinCache((int)(50.0 * this.ratio));
        DLTKCore.addElementChangedListener(this.changedListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.changedListener);
    }

    public void stop() {
        DLTKCore.removeElementChangedListener(this.changedListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.changedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMixinElement get(String key) {
        if (this.notExistKeysCache.contains(key)) {
            return null;
        }
        if (this.removes == 0L && this.cache.get(key) == null) {
            return null;
        }
        MixinElement element = this.getCreateEmpty(key);
        this.buildElementTree(element);
        if (element.isFinal() && element.sourceModules.size() > 0) {
            this.existKeysCache.add(key);
            return element;
        }
        this.notExistKeysCache.add(key);
        MixinCache mixinCache = this.cache;
        synchronized (mixinCache) {
            this.cache.remove(element);
            this.cache.resetSpaceLimit(50, element);
            this.cache.removeKey(element);
        }
        return null;
    }

    public IMixinElement[] find(String pattern) {
        HashSet set = new HashSet();
        ISourceModule[] containedModules = SearchEngine.searchMixinSources(pattern, this.toolkit, set);
        if (containedModules.length == 0) {
            return new IMixinElement[0];
        }
        int i = 0;
        while (i < containedModules.length) {
            this.reportModule(containedModules[i]);
            ++i;
        }
        IMixinElement[] result = new IMixinElement[set.size()];
        int i2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            MixinElement element = this.getCreateEmpty(key);
            this.markElementAsFinal(element);
            result[i2++] = element;
            this.existKeysCache.add(key);
        }
        return result;
    }

    public String[] findKeys(String pattern) {
        return SearchEngine.searchMixinPatterns(pattern, this.toolkit);
    }

    public boolean keyExists(String key) {
        boolean exist;
        if (this.removes == 0L) {
            return this.cache.get(key) != null;
        }
        MixinElement e = (MixinElement)this.cache.get(key);
        if (e != null && e.sourceModules.size() > 0) {
            return true;
        }
        if (this.existKeysCache.contains(key)) {
            return true;
        }
        if (this.notExistKeysCache.contains(key)) {
            return false;
        }
        boolean bl = exist = this.get(key) != null;
        if (exist) {
            if (this.existKeysCache.size() > 500000) {
                this.existKeysCache.clear();
            }
            this.existKeysCache.add(key);
        } else {
            if (this.notExistKeysCache.size() > 500000) {
                this.notExistKeysCache.clear();
            }
            this.notExistKeysCache.add(key);
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildElementTree(MixinElement element) {
        if (element.isFinal()) {
            return;
        }
        ISourceModule[] containedModules = this.findModules(element.getKey());
        if (containedModules.length == 0) {
            MixinCache mixinCache = this.cache;
            synchronized (mixinCache) {
                this.cache.remove(element);
                this.cache.resetSpaceLimit(50, element);
                this.cache.removeKey(element.key);
            }
            return;
        }
        int i = 0;
        while (i < containedModules.length) {
            this.reportModule(containedModules[i]);
            ++i;
        }
        this.markElementAsFinal(element);
    }

    private synchronized void markElementAsFinal(MixinElement element) {
        element.bFinal = true;
        Iterator i = element.children.iterator();
        while (i.hasNext()) {
            this.markElementAsFinal((MixinElement)i.next());
        }
    }

    public synchronized void reportModule(ISourceModule sourceModule) {
        if (!this.elementToMixinCache.containsKey(sourceModule)) {
            this.elementToMixinCache.put(sourceModule, new ArrayList());
        } else {
            if (!this.modulesToReparse.contains(sourceModule)) {
                return;
            }
            this.modulesToReparse.remove(sourceModule);
        }
        try {
            IMixinParser mixinParser = MixinManager.getMixinParser(sourceModule);
            if (mixinParser != null) {
                this.currentModule = sourceModule;
                char[] content = sourceModule.getSourceAsCharArray();
                mixinParser.setRequirestor(this.mixinRequestor);
                ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
                ISourceModuleInfoCache.ISourceModuleInfo mifo = sourceModuleInfoCache.get(sourceModule);
                mixinParser.parserSourceModule(content, true, sourceModule, mifo);
                if (mifo.isEmpty()) {
                    sourceModuleInfoCache.remove(sourceModule);
                }
                this.currentModule = null;
            }
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return;
        }
    }

    private ISourceModule[] findModules(String key) {
        ISourceModule[] searchMixinSources = SearchEngine.searchMixinSources(key, this.toolkit);
        return searchMixinSources;
    }

    private synchronized MixinElement getCreateEmpty(String key) {
        MixinElement element = (MixinElement)this.cache.get(key);
        if (element == null) {
            element = new MixinElement(key, this.currentModule);
            this.cache.put(key, element);
            this.cache.ensureSpaceLimit(1, element);
        }
        return element;
    }

    public synchronized void remove(ISourceModule element) {
        if (this.elementToMixinCache.containsKey(element)) {
            List elements = (List)this.elementToMixinCache.get(element);
            int i = 0;
            while (i < elements.size()) {
                ++this.removes;
                MixinElement mixin = (MixinElement)elements.get(i);
                this.existKeysCache.remove(mixin.key);
                this.notExistKeysCache.remove(mixin.key);
                mixin.bFinal = false;
                mixin.sourceModules.remove(element);
                mixin.sourceModuleToObject.remove(element);
                if (mixin.sourceModules.size() == 0) {
                    MixinElement parent;
                    String parentKey = mixin.getParentKey();
                    if (parentKey != null && (parent = (MixinElement)this.cache.get(parentKey)) != null) {
                        parent.children.remove(mixin);
                        parent.bFinal = false;
                    }
                    this.cache.remove(mixin);
                    this.cache.resetSpaceLimit(50, mixin);
                }
                ++i;
            }
            this.elementToMixinCache.remove(element);
        }
    }

    public void makeAllModuleElementsFinal(ISourceModule module) {
        if (this.elementToMixinCache.containsKey(module)) {
            List elements = (List)this.elementToMixinCache.get(module);
            int i = 0;
            while (i < elements.size()) {
                ++this.removes;
                MixinElement mixin = (MixinElement)elements.get(i);
                mixin.bFinal = true;
                ++i;
            }
        }
    }

    public void makeAllElementsFinalIfNoCacheRemoves() {
        if (this.removes != 0L) {
            return;
        }
        Enumeration elements = this.cache.elements();
        while (elements.hasMoreElements()) {
            MixinElement e = (MixinElement)elements.nextElement();
            e.bFinal = true;
        }
    }

    public void setRemovesToZero() {
        this.removes = 0L;
    }

    public void clearKeysCashe(String key) {
        this.existKeysCache.remove(key);
        this.notExistKeysCache.remove(key);
    }

    public void addObjectInitializeListener(IMixinObjectInitializeListener mixinObjectInitializeListener) {
        this.mixinObjectInitializeListeners.add((Object)mixinObjectInitializeListener);
    }

    public void removeObjectInitializeListener(IMixinObjectInitializeListener mixinObjectInitializeListener) {
        this.mixinObjectInitializeListeners.remove((Object)mixinObjectInitializeListener);
    }

    private void notifyInitializeListener(IMixinElement element, ISourceModule module, Object o) {
        Object[] listeners = this.mixinObjectInitializeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IMixinObjectInitializeListener)listeners[i]).initialize(element, o, module);
            ++i;
        }
    }

    private static interface IMixinChangedListener
    extends IElementChangedListener,
    IResourceChangeListener {
    }

    public static interface IMixinObjectInitializeListener {
        public void initialize(IMixinElement var1, Object var2, ISourceModule var3);
    }

    private class MixinElement
    implements IMixinElement,
    IInternalMixinElement {
        private String key;
        private boolean bFinal = false;
        private List sourceModules = new ArrayList();
        private Map sourceModuleToObject = new HashMap();
        private Set children = new HashSet();

        public boolean equals(Object obj) {
            if (obj instanceof MixinElement) {
                return this.key.equals(((MixinElement)obj).key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public MixinElement(String key) {
            this.key = key;
        }

        public String toString() {
            return String.valueOf(this.getLastKeySegment()) + " final[" + this.bFinal + "]" + this.children + " ";
        }

        public MixinElement(IMixinRequestor.ElementInfo info, ISourceModule module) {
            this(info.key, mixinModel.currentModule);
            this.addInfo(info, module);
        }

        void addInfo(IMixinRequestor.ElementInfo info, ISourceModule module) {
            if (info.object != null) {
                Object object = this.sourceModuleToObject.get(module);
                if (object != null) {
                    if (object instanceof List) {
                        ((List)object).add(info.object);
                    } else {
                        ArrayList<Object> l = new ArrayList<Object>();
                        l.add(object);
                        l.add(info.object);
                        object = l;
                        this.sourceModuleToObject.put(module, object);
                    }
                } else {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(info.object);
                    object = l;
                    this.sourceModuleToObject.put(module, object);
                }
            }
        }

        public MixinElement(String key, ISourceModule currentModule) {
            this.key = key;
            this.addModule(currentModule);
        }

        void addModule(ISourceModule currentModule) {
            if (currentModule != null && !this.sourceModules.contains(currentModule)) {
                this.sourceModules.add(currentModule);
            }
        }

        public IMixinElement[] getChildren() {
            this.validate();
            return this.children.toArray(new IMixinElement[this.children.size()]);
        }

        public IMixinElement getChildren(String key) {
            this.validate();
            return MixinModel.this.get(String.valueOf(this.key) + MixinModel.SEPARATOR + key);
        }

        public String getKey() {
            return this.key;
        }

        protected String getParentKey() {
            if (this.key.indexOf(MixinModel.SEPARATOR) == -1) {
                return null;
            }
            return this.key.substring(0, this.key.lastIndexOf(MixinModel.SEPARATOR));
        }

        public String getLastKeySegment() {
            if (this.key.indexOf(MixinModel.SEPARATOR) == -1) {
                return this.key;
            }
            return this.key.substring(1 + this.key.lastIndexOf(MixinModel.SEPARATOR));
        }

        public IMixinElement getParent() {
            String parentKey = this.getParentKey();
            if (parentKey == null) {
                return null;
            }
            return MixinModel.this.get(parentKey);
        }

        public ISourceModule[] getSourceModules() {
            this.validate();
            if (!this.isFinal()) {
                MixinModel.this.get(this.key);
            }
            return this.sourceModules.toArray(new ISourceModule[this.sourceModules.size()]);
        }

        public Object[] getObjects(ISourceModule module) {
            this.validate();
            Object o = this.sourceModuleToObject.get(module);
            if (o instanceof List) {
                Object[] objs = ((List)o).toArray();
                int i = 0;
                while (i < objs.length) {
                    MixinModel.this.notifyInitializeListener(this, module, objs[i]);
                    ++i;
                }
                return objs;
            }
            MixinModel.this.notifyInitializeListener(this, module, o);
            return new Object[]{o};
        }

        public Object[] getAllObjects() {
            this.validate();
            HashSet<Object> objects = new HashSet<Object>();
            Iterator iterator = this.sourceModules.iterator();
            while (iterator.hasNext()) {
                ISourceModule module = (ISourceModule)iterator.next();
                Object[] objs = this.getObjects(module);
                int j = 0;
                while (j < objs.length) {
                    objects.add(objs[j]);
                    ++j;
                }
            }
            return objects.toArray();
        }

        public boolean isFinal() {
            return this.bFinal;
        }

        public void close() {
            MixinModel.this.existKeysCache.remove(this.key);
            MixinModel.this.notExistKeysCache.remove(this.key);
            ++MixinModel.this.removes;
            this.bFinal = false;
            int i = 0;
            while (i < this.sourceModules.size()) {
                Object module = this.sourceModules.get(i);
                List list = (List)MixinModel.this.elementToMixinCache.get(module);
                if (list != null) {
                    list.remove(this);
                    if (list.size() == 0) {
                        MixinModel.this.elementToMixinCache.remove(module);
                    }
                }
                if (!MixinModel.this.modulesToReparse.contains(module) && MixinModel.this.elementToMixinCache.containsKey(module)) {
                    MixinModel.this.modulesToReparse.add(module);
                }
                ++i;
            }
            this.sourceModules.clear();
            this.sourceModuleToObject.clear();
            String parentKey = this.getParentKey();
            MixinElement element = this;
            while (parentKey != null) {
                MixinElement parent = (MixinElement)MixinModel.this.cache.get(parentKey);
                if (parent == null) break;
                MixinModel.this.existKeysCache.remove(parent.key);
                MixinModel.this.notExistKeysCache.remove(parent.key);
                parent.children.remove(element);
                parent.bFinal = false;
                element = parent;
                parentKey = parent.getParentKey();
            }
        }

        private void validate() {
            if (!this.isFinal()) {
                MixinModel.this.buildElementTree(this);
            }
        }
    }

    private class MixinRequestor
    implements IMixinRequestor {
        private MixinRequestor() {
        }

        public void reportElement(IMixinRequestor.ElementInfo info) {
            MixinModel.this.existKeysCache.add(info.key);
            String[] list = info.key.split("\\{");
            MixinElement element = MixinModel.this.getCreateEmpty(info.key);
            this.addElementToModules(element);
            element.addModule(MixinModel.this.currentModule);
            element.addInfo(info, MixinModel.this.currentModule);
            if (list.length != 1) {
                int i = 0;
                while (i < list.length - 1) {
                    MixinElement parent = MixinModel.this.getCreateEmpty(element.getParentKey());
                    if (!parent.children.contains(element)) {
                        parent.children.add(element);
                    }
                    this.addElementToModules(parent);
                    element = parent;
                    ++i;
                }
            }
        }

        private void addElementToModules(MixinElement element) {
            ArrayList<MixinElement> elements = (ArrayList<MixinElement>)MixinModel.this.elementToMixinCache.get(MixinModel.this.currentModule);
            if (elements == null) {
                elements = new ArrayList<MixinElement>();
                MixinModel.this.elementToMixinCache.put(MixinModel.this.currentModule, elements);
            }
            elements.add(element);
        }
    }
}

