/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.rename;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringArguments;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptorComment;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.RenameScriptProjectChange;
import org.eclipse.dltk.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.dltk.internal.corext.refactoring.participants.ScriptProcessors;
import org.eclipse.dltk.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.dltk.internal.corext.refactoring.rename.ScriptRenameProcessor;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public class RenameScriptProjectProcessor
extends ScriptRenameProcessor
implements IReferenceUpdating {
    private static final String ID_RENAME_SCRIPT_PROJECT = "org.eclipse.dltk.ui.rename.script.project";
    private static final String ATTRIBUTE_REFERENCES = "references";
    private IScriptProject fProject;
    private boolean fUpdateReferences;
    public static final String IDENTIFIER = "org.eclipse.dltk.ui.renameScriptProjectProcessor";

    public RenameScriptProjectProcessor(IScriptProject project) {
        this.fProject = project;
        if (this.fProject != null) {
            this.setNewElementName(this.fProject.getElementName());
        }
        this.fUpdateReferences = true;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fProject);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameScriptProjectRefactoring_rename;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return ScriptProcessors.computeAffectedNatures((IModelElement)this.fProject);
    }

    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    public Object getNewElement() throws CoreException {
        IPath newPath = this.fProject.getPath().removeLastSegments(1).append(this.getNewElementName());
        return DLTKCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath));
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fProject, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        IFile projectFile = this.fProject.getProject().getFile(".project");
        if (projectFile != null && projectFile.exists()) {
            return new IFile[]{projectFile};
        }
        return new IFile[0];
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String getCurrentElementName() {
        return this.fProject.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = RefactoringStatus.create((IStatus)ResourcesPlugin.getWorkspace().validateName(newName, 4));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.projectNameAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameScriptProjectRefactoring_already_exists);
        }
        if (this.projectFolderAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameScriptProjectProcessor_folder_already_exists);
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            pm.beginTask("", 1);
            try {
                if (!this.isReadOnly()) break block3;
                String message = Messages.format(RefactoringCoreMessages.RenameScriptProjectRefactoring_read_only, this.fProject.getElementName());
                refactoringStatus = RefactoringStatus.createErrorStatus((String)message);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Object var4_7 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean isReadOnly() {
        return Resources.isReadOnly(this.fProject.getResource());
    }

    private boolean projectNameAlreadyExists(String newName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(newName).exists();
    }

    private boolean projectFolderAlreadyExists(String newName) throws CoreException {
        boolean isNotInWorkpace;
        boolean bl = isNotInWorkpace = this.fProject.getProject().getDescription().getLocationURI() != null;
        if (isNotInWorkpace) {
            return false;
        }
        URI locationURI = this.fProject.getProject().getLocationURI();
        IFileStore projectStore = EFS.getStore((URI)locationURI);
        IFileStore newProjectStore = projectStore.getParent().getChild(newName);
        return newProjectStore.fetchInfo().exists();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String description = Messages.format(RefactoringCoreMessages.RenameScriptProjectProcessor_descriptor_description_short, this.fProject.getElementName());
            String header = Messages.format(RefactoringCoreMessages.RenameScriptProjectChange_descriptor_description, new String[]{this.fProject.getElementName(), this.getNewElementName()});
            String comment = new ScriptRefactoringDescriptorComment(this, header).asString();
            ScriptRefactoringDescriptor descriptor = new ScriptRefactoringDescriptor(ID_RENAME_SCRIPT_PROJECT, null, description, comment, arguments, 7);
            arguments.put("input", descriptor.elementToHandle((IModelElement)this.fProject));
            arguments.put("name", this.getNewElementName());
            arguments.put(ATTRIBUTE_REFERENCES, Boolean.valueOf(this.fUpdateReferences).toString());
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameScriptProjectChange((RefactoringDescriptor)descriptor, this.fProject, this.getNewElementName(), comment, this.fUpdateReferences));
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (arguments instanceof ScriptRefactoringArguments) {
            IModelElement element;
            ScriptRefactoringArguments extended = (ScriptRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = ScriptRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 2) {
                    return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), ID_RENAME_SCRIPT_PROJECT);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fProject = (IScriptProject)element;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName(name);
            references = extended.getAttribute(ATTRIBUTE_REFERENCES);
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REFERENCES));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }
}

