/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalEntryFile;
import org.eclipse.dltk.internal.core.ExternalScriptFolderInfo;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;

public class ExternalScriptFolder
extends ScriptFolder {
    public ExternalScriptFolder(ProjectFragment parent, IPath path) {
        super(parent, path);
    }

    void computeForeignResources(ExternalScriptFolderInfo info, List resNames) {
        if (resNames == null) {
            info.setForeignResources(ModelElementInfo.NO_NON_SCRIPT_RESOURCES);
            return;
        }
        int max = resNames.size();
        if (max == 0) {
            info.setForeignResources(ModelElementInfo.NO_NON_SCRIPT_RESOURCES);
        } else {
            Object[] res = new Object[max];
            int index = 0;
            int i = 0;
            while (i < max) {
                IPath resPath = (IPath)resNames.get(i);
                if (!Util.isValidSourceModule((IModelElement)this.getScriptProject(), resPath)) {
                    res[index++] = new ExternalEntryFile((IPath)resNames.get(i));
                }
                ++i;
            }
            if (index != max) {
                Object[] objectArray = res;
                res = new Object[index];
                System.arraycopy(objectArray, 0, res, 0, index);
            }
            info.setForeignResources(res);
        }
    }

    public ISourceModule getSourceModule(String name) {
        return new ExternalSourceModule(this, name, DefaultWorkingCopyOwner.PRIMARY, new ExternalEntryFile(this.getPath().append(name)));
    }

    protected boolean computeChildren(OpenableElementInfo info, List entryNames) {
        if (entryNames != null && entryNames.size() > 0) {
            ArrayList<ISourceModule> vChildren = new ArrayList<ISourceModule>();
            Iterator iter = entryNames.iterator();
            while (iter.hasNext()) {
                String child = ((IPath)iter.next()).lastSegment();
                ISourceModule classFile = this.getSourceModule(child);
                vChildren.add(classFile);
            }
            IModelElement[] children = new IModelElement[vChildren.size()];
            vChildren.toArray(children);
            info.setChildren(children);
        } else {
            info.setChildren(NO_ELEMENTS);
        }
        return true;
    }

    public ISourceModule[] getSourceModules() throws ModelException {
        ArrayList list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws ModelException {
        Openable openableParent = (Openable)this.parent;
        if (!openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)((Object)this.getSourceModule(classFileName));
                return classFile.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected Object createElementInfo() {
        return null;
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        File file = new File(this.getPath().toOSString());
        return file != null && file.exists() && file.isDirectory();
    }

    public Object[] getForeignResources() throws ModelException {
        return ((ExternalScriptFolderInfo)this.getElementInfo()).getForeignResources();
    }
}

