/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.indexing.IndexRequest;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.internal.core.search.processing.JobManager;
import org.eclipse.dltk.internal.core.util.Util;

public class SaveIndex
extends IndexRequest {
    public SaveIndex(IPath containerPath, IndexManager manager) {
        super(containerPath, manager);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, false);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterWrite();
                this.manager.saveIndex(index);
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> failed to save index " + this.containerPath + " because of the following exception:", System.err);
                    e.printStackTrace();
                }
                Object var5_5 = null;
                monitor.exitWrite();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.exitWrite();
            throw throwable;
        }
        {
            Object var5_7 = null;
            monitor.exitWrite();
            return true;
        }
    }

    public String toString() {
        return "saving index for " + this.containerPath;
    }
}

