/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AccessRulesLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof IAccessRule) {
            IAccessRule rule = (IAccessRule)element;
            if (columnIndex == 0) {
                return AccessRulesLabelProvider.getResolutionImage(rule.getKind());
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IAccessRule) {
            IAccessRule rule = (IAccessRule)element;
            if (columnIndex == 0) {
                return AccessRulesLabelProvider.getResolutionLabel(rule.getKind());
            }
            return rule.getPattern().toString();
        }
        return element.toString();
    }

    public static Image getResolutionImage(int kind) {
        switch (kind) {
            case 0: {
                return DLTKPluginImages.get("org.eclipse.dltk.ui.translate.gif");
            }
            case 2: {
                return DLTKPluginImages.get("org.eclipse.dltk.ui.warning_obj.gif");
            }
            case 1: {
                return DLTKPluginImages.get("org.eclipse.dltk.ui.error_obj.gif");
            }
        }
        return null;
    }

    public static String getResolutionLabel(int kind) {
        switch (kind) {
            case 0: {
                return NewWizardMessages.AccessRulesLabelProvider_kind_accessible;
            }
            case 2: {
                return NewWizardMessages.AccessRulesLabelProvider_kind_discouraged;
            }
            case 1: {
                return NewWizardMessages.AccessRulesLabelProvider_kind_non_accessible;
            }
        }
        return "";
    }
}

