/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.MoveElementsOperation;
import org.eclipse.dltk.internal.core.util.Messages;

public class RenameElementsOperation
extends MoveElementsOperation {
    public RenameElementsOperation(IModelElement[] elements, IModelElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, force);
        this.setRenamings(newNames);
    }

    protected String getMainTaskName() {
        return Messages.operation_renameElementProgress;
    }

    protected boolean isRename() {
        return true;
    }

    protected IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList == null || this.renamingsList.length == 0) {
            return new ModelStatus(982);
        }
        return ModelStatus.VERIFIED_OK;
    }

    protected void verify(IModelElement element) throws ModelException {
        int elementType = element.getElementType();
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        if (!(element instanceof ISourceReference)) {
            this.error(967, element);
        }
        if (elementType < 7) {
            this.error(967, element);
        }
        this.verifyRenaming(element);
    }
}

