/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.launching.LibraryLocation;

public final class LibraryStandin {
    private IPath fSystemLibrary;

    public LibraryStandin(LibraryLocation libraryLocation) {
        this.fSystemLibrary = libraryLocation.getLibraryPath();
    }

    public IPath getSystemLibraryPath() {
        return this.fSystemLibrary;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LibraryStandin) {
            LibraryStandin lib = (LibraryStandin)obj;
            return this.getSystemLibraryPath().equals((Object)lib.getSystemLibraryPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystemLibraryPath().hashCode();
    }

    protected boolean equals(IPath path1, IPath path2) {
        return this.equalsOrNull(path1, path2);
    }

    private boolean equalsOrNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public LibraryLocation toLibraryLocation() {
        return new LibraryLocation(this.getSystemLibraryPath());
    }

    public IStatus validate() {
        File f = this.getSystemLibraryPath().toFile();
        if (!f.exists()) {
            IPath path = this.getSystemLibraryPath();
            String message = "Path is empty";
            if (path != null) {
                message = path.toOSString();
            }
            return new Status(4, "org.eclipse.dltk.debug.ui", 0, MessageFormat.format(InterpretersMessages.LibraryStandin_0, message), null);
        }
        return Status.OK_STATUS;
    }
}

