/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.core;

import java.util.Hashtable;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.dltk.ui.tests.TestOptions;

public class ProjectTestSetup
extends TestSetup {
    public static final String PROJECT_NAME = "TestSetupProject";
    private IScriptProject fJProject;
    private boolean fAutobuilding;

    public static IScriptProject getProject() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        return DLTKCore.create((IProject)project);
    }

    public ProjectTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IScriptProject project = ProjectTestSetup.getProject();
        if (project.exists()) {
            return;
        }
        this.fAutobuilding = ScriptProjectHelper.setAutoBuilding(false);
        this.fJProject = ScriptProjectHelper.createScriptProject(PROJECT_NAME);
        TestOptions.initializeProjectOptions(this.fJProject);
        DLTKCore.setOptions((Hashtable)TestOptions.getDefaultOptions());
        TestOptions.initializeCodeGenerationOptions();
    }

    protected void tearDown() throws Exception {
        if (this.fJProject != null) {
            ScriptProjectHelper.delete((IModelElement)this.fJProject);
            ScriptProjectHelper.setAutoBuilding(this.fAutobuilding);
        }
    }
}

