/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.utils;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpSessionInfo;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.exceptions.DbgpProtocolException;
import org.eclipse.dltk.dbgp.internal.DbgpFeature;
import org.eclipse.dltk.dbgp.internal.DbgpProperty;
import org.eclipse.dltk.dbgp.internal.DbgpSessionInfo;
import org.eclipse.dltk.dbgp.internal.DbgpStackLevel;
import org.eclipse.dltk.dbgp.internal.DbgpStatus;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpCallBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpConditionalBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpExceptionBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpLineBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpReturnBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpWatchBreakpoint;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbgpXmlEntityParser
extends DbgpXmlParser {
    protected DbgpXmlEntityParser() {
    }

    public static DbgpStackLevel parseStackLevel(Element element) throws DbgpException {
        int level = Integer.parseInt(element.getAttribute("level"));
        String cmdBegin = element.getAttribute("cmdbegin");
        String cmdEnd = element.getAttribute("cmdend");
        int lineBegin = -1;
        int lineEnd = -1;
        if (!"".equals(cmdBegin) && !"".equals(cmdEnd)) {
            lineBegin = DbgpXmlEntityParser.getPosition(cmdBegin);
            lineEnd = DbgpXmlEntityParser.getPosition(cmdEnd);
        }
        int lineNumber = Integer.parseInt(element.getAttribute("lineno"));
        URI fileUri = null;
        String fileName = element.getAttribute("filename");
        fileUri = URI.create(fileName);
        String where = element.getAttribute("where");
        return new DbgpStackLevel(fileUri, where, level, lineNumber, lineBegin, lineEnd);
    }

    public static DbgpFeature parseFeature(Element element) throws DbgpProtocolException {
        String name = element.getAttribute("feature_name");
        boolean supported = DbgpXmlEntityParser.makeBoolean(element.getAttribute("supported"));
        String value = DbgpXmlEntityParser.parseContent(element);
        return new DbgpFeature(supported, name, value);
    }

    public static IDbgpProperty parseProperty(Element property) {
        String name = property.getAttribute("name");
        String fullName = property.getAttribute("fullname");
        String type = property.getAttribute("type");
        boolean hasChildren = false;
        if (property.hasAttribute("children")) {
            hasChildren = DbgpXmlEntityParser.makeBoolean(property.getAttribute("children"));
        }
        int childrenCount = -1;
        if (property.hasAttribute("numchildren")) {
            childrenCount = Integer.parseInt(property.getAttribute("numchildren"));
        }
        int size = -1;
        if (property.hasAttribute("size")) {
            size = Integer.parseInt(property.getAttribute("size"));
        }
        boolean constant = false;
        if (property.hasAttribute("constant")) {
            constant = DbgpXmlEntityParser.makeBoolean(property.getAttribute("constant"));
        }
        String key = null;
        if (property.hasAttribute("key")) {
            key = property.getAttribute("key");
        }
        String value = "";
        if (!hasChildren) {
            String encoding = "none";
            if (property.hasAttribute("encoding")) {
                encoding = property.getAttribute("encoding");
            }
            if (encoding.equals("none")) {
                value = DbgpXmlEntityParser.parseContent(property);
            } else if (encoding.equals("base64")) {
                value = DbgpXmlEntityParser.parseBase64Content(property);
            } else {
                throw new AssertionError();
            }
        }
        ArrayList<IDbgpProperty> availableChildren = new ArrayList<IDbgpProperty>();
        if (hasChildren) {
            NodeList properties = property.getChildNodes();
            int i = 0;
            while (i < properties.getLength()) {
                Node item = properties.item(i);
                if (item instanceof Element) {
                    availableChildren.add(DbgpXmlEntityParser.parseProperty((Element)item));
                }
                ++i;
            }
        }
        return new DbgpProperty(name, fullName, type, value, size, childrenCount, hasChildren, constant, key, availableChildren.toArray(new IDbgpProperty[availableChildren.size()]));
    }

    public static IDbgpStatus parseStatus(Element element) throws DbgpProtocolException {
        String status = element.getAttribute("status");
        String reason = element.getAttribute("reason");
        return DbgpStatus.parse(status, reason);
    }

    public static IDbgpBreakpoint parseBreakpoint(Element element) {
        String type = element.getAttribute("type");
        String id = element.getAttribute("id");
        boolean enabled = element.getAttribute("state").equals("enabled");
        int hitCount = Integer.parseInt(element.getAttribute("hit_count"));
        int hitValue = Integer.parseInt(element.getAttribute("hit_value"));
        String hitCondition = element.getAttribute("hit_condition");
        if (type.equals("line")) {
            String fileName = element.getAttribute("filename");
            int lineNumber = Integer.parseInt(element.getAttribute("lineno"));
            return new DbgpLineBreakpoint(id, enabled, hitValue, hitCount, hitCondition, fileName, lineNumber);
        }
        if (type.equals("call")) {
            String function = element.getAttribute("function");
            return new DbgpCallBreakpoint(id, enabled, hitValue, hitCount, hitCondition, function);
        }
        if (type.equals("return")) {
            String function = element.getAttribute("function");
            return new DbgpReturnBreakpoint(id, enabled, hitValue, hitCount, hitCondition, function);
        }
        if (type.equals("exception")) {
            String exception = element.getAttribute("exception");
            return new DbgpExceptionBreakpoint(id, enabled, hitValue, hitCount, hitCondition, exception);
        }
        if (type.equals("conditional")) {
            String expression = element.getAttribute("expression");
            return new DbgpConditionalBreakpoint(id, enabled, hitValue, hitCount, hitCondition, expression);
        }
        if (type.equals("watch")) {
            String expression = element.getAttribute("expression");
            return new DbgpWatchBreakpoint(id, enabled, hitValue, hitCount, hitCondition, expression);
        }
        return null;
    }

    public static IDbgpSessionInfo parseSession(Element element) {
        String appId = element.getAttribute("appid");
        String ideKey = element.getAttribute("idekey");
        String session = element.getAttribute("session");
        String threadId = element.getAttribute("thread");
        String parentId = element.getAttribute("parent");
        String language = element.getAttribute("language");
        return new DbgpSessionInfo(appId, ideKey, session, threadId, parentId, language, null);
    }
}

