/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ICallProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.dltk.internal.corext.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.corext.callhierarchy.CallSearchResultCollector;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodCall;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.dltk.ui.DLTKUIPlugin;

class CallerMethodWrapper
extends MethodWrapper {
    public CallerMethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        super(parent, methodCall);
    }

    protected IDLTKSearchScope getSearchScope() {
        IModelElement el = this.getMember();
        IDLTKLanguageToolkit toolkit = null;
        try {
            toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)el);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return CallHierarchy.getDefault().getSearchScope(toolkit);
    }

    protected String getTaskName() {
        return CallHierarchyMessages.CallerMethodWrapper_taskname;
    }

    protected MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CallerMethodWrapper(this, methodCall);
    }

    protected Map findChildren(IProgressMonitor progressMonitor) {
        try {
            CallSearchResultCollector fSearchResults = new CallSearchResultCollector();
            SubProgressMonitor monitor = new SubProgressMonitor(progressMonitor, 95, 2);
            IDLTKSearchScope defaultSearchScope = this.getSearchScope();
            IModelElement el = this.getMember();
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)el);
            boolean isWorkspaceScope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit).equals(defaultSearchScope);
            ICallProcessor processor = DLTKLanguageManager.createCallProcessor((String)toolkit.getNatureId());
            if (processor == null) {
                return fSearchResults.getCallers();
            }
            Iterator iter = this.getMembers().iterator();
            while (iter.hasNext()) {
                this.checkCanceled(progressMonitor);
                IMember member = (IMember)iter.next();
                IDLTKSearchScope searchScope = isWorkspaceScope ? this.getAccurateSearchScope(defaultSearchScope, (IModelElement)member) : defaultSearchScope;
                Map elements = processor.process(el, (IModelElement)member, searchScope, (IProgressMonitor)monitor);
                Iterator i = elements.keySet().iterator();
                while (i.hasNext()) {
                    SimpleReference ref = (SimpleReference)i.next();
                    IModelElement ell = (IModelElement)elements.get(ref);
                    switch (ell.getElementType()) {
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: {
                            fSearchResults.addMember(ell, ell, ref.sourceStart(), ref.sourceEnd());
                        }
                    }
                }
            }
            return fSearchResults.getCallers();
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
            return new HashMap(0);
        }
    }

    private IDLTKSearchScope getAccurateSearchScope(IDLTKSearchScope defaultSearchScope, IModelElement member) throws ModelException {
        return defaultSearchScope;
    }

    private Collection getMembers() {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        result.add(this.getMember());
        return result;
    }
}

