/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.dltk.dbgp.internal.DbgpRawPacket;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.packets.DbgpNotifyPacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpStreamPacket;
import org.eclipse.dltk.dbgp.internal.packets.IDbgpRawLogger;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlPacketParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbgpPacketReceiver
extends DbgpWorkingThread {
    private static final String INIT_TAG = "init";
    private static final String RESPONSE_TAG = "response";
    private static final String STREAM_TAG = "stream";
    private static final String NOTIFY_TAG = "notify";
    private final SyncMap responseQueue;
    private final SyncQueue notifyQueue;
    private final SyncQueue streamQueue;
    private final InputStream input;
    private IDbgpRawLogger logger;

    protected void workingCycle() throws Exception {
        while (!Thread.interrupted()) {
            DbgpRawPacket packet = DbgpRawPacket.readPacket(this.input);
            if (this.logger != null) {
                this.logger.log(packet.toString());
            }
            this.addDocument(packet.getParsedXml());
        }
    }

    protected void addDocument(Document doc) {
        Element element = (Element)doc.getFirstChild();
        String tag = element.getTagName();
        if (tag.equals(INIT_TAG)) {
            this.responseQueue.put(new Integer(-1), new DbgpResponsePacket(element, -1));
        } else if (tag.equals(RESPONSE_TAG)) {
            DbgpResponsePacket packet = DbgpXmlPacketParser.parseResponsePacket(element);
            this.responseQueue.put(new Integer(packet.getTransactionId()), packet);
        } else if (tag.equals(STREAM_TAG)) {
            this.streamQueue.put(DbgpXmlPacketParser.parseStreamPacket(element));
        } else if (tag.equals(NOTIFY_TAG)) {
            this.notifyQueue.put(DbgpXmlPacketParser.parseNotifyPacket(element));
        }
    }

    public DbgpNotifyPacket getNotifyPacket() throws InterruptedException {
        return (DbgpNotifyPacket)this.notifyQueue.get();
    }

    public DbgpStreamPacket getStreamPacket() throws InterruptedException {
        return (DbgpStreamPacket)this.streamQueue.get();
    }

    public DbgpResponsePacket getResponsePacket(int transactionId) throws InterruptedException {
        return (DbgpResponsePacket)this.responseQueue.get(new Integer(transactionId));
    }

    public DbgpPacketReceiver(InputStream input) {
        super("DBGP - Packet receiver");
        if (input == null) {
            throw new IllegalArgumentException();
        }
        this.input = input;
        this.notifyQueue = new SyncQueue();
        this.streamQueue = new SyncQueue();
        this.responseQueue = new SyncMap();
    }

    public void setLogger(IDbgpRawLogger logger) {
        this.logger = logger;
    }

    private static class SyncMap {
        private final HashMap map = new HashMap();

        public synchronized void put(Object key, Object value) {
            this.map.put(key, value);
            this.notifyAll();
        }

        public synchronized Object get(Object key) throws InterruptedException {
            while (!this.map.containsKey(key)) {
                this.wait();
            }
            return this.map.remove(key);
        }

        public synchronized int size() {
            return this.map.size();
        }
    }

    private static class SyncQueue {
        private final LinkedList queue = new LinkedList();

        public synchronized void put(Object obj) {
            this.queue.addLast(obj);
            this.notifyAll();
        }

        public synchronized Object get() throws InterruptedException {
            while (this.queue.isEmpty()) {
                this.wait();
            }
            return this.queue.removeFirst();
        }
    }
}

