/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ruby.ast.RubySelfReference;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.MethodReturnTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class MethodCallTypeEvaluator
extends GoalEvaluator {
    private static final int STATE_INIT = 0;
    private static final int STATE_WAITING_RECEIVER = 1;
    private static final int STATE_GOT_RECEIVER = 2;
    private static final int STATE_WAITING_ARGUMENT_0 = 3;
    private static final int STATE_WAITING_ARGUMENT_LAST = 9999;
    private static final int STATE_ARGS_DONE = 10000;
    private static final int STATE_WAITING_METHOD = 10001;
    private static final int STATE_UNKNOWN = -1;
    private static final int STATE_DONE = -2;
    private int state = 0;
    private IEvaluatedType receiverType;
    private IEvaluatedType[] arguments;
    private IEvaluatedType result;

    public MethodCallTypeEvaluator(ExpressionTypeGoal goal) {
        super((IGoal)goal);
    }

    private IGoal produceNextSubgoal(IGoal previousGoal, Object previousResult) {
        CallExpression expression;
        ExpressionTypeGoal typedGoal;
        if (this.state == 0) {
            typedGoal = (ExpressionTypeGoal)this.goal;
            expression = (CallExpression)typedGoal.getExpression();
            ASTNode receiver = expression.getReceiver();
            if (receiver == null || receiver instanceof RubySelfReference) {
                this.receiverType = RubyTypeInferencingUtils.determineSelfClass(this.goal.getContext(), expression.sourceStart());
                this.state = 2;
            } else {
                this.state = 1;
                return new ExpressionTypeGoal(this.goal.getContext(), receiver);
            }
        }
        if (this.state == 1) {
            this.receiverType = (IEvaluatedType)previousResult;
            if (this.receiverType == null) {
                this.state = -1;
                return null;
            }
            this.state = 2;
        }
        if (this.state == 2) {
            typedGoal = (ExpressionTypeGoal)this.goal;
            expression = (CallExpression)typedGoal.getExpression();
            List arguments = expression.getArgs().getExpressions();
            this.arguments = new IEvaluatedType[arguments.size()];
        }
        if (this.state >= 3 && this.state <= 9999) {
            this.arguments[this.state - 3] = (IEvaluatedType)previousResult;
        }
        if (this.state == 2 || this.state >= 3 && this.state <= 9999) {
            ExpressionTypeGoal typedGoal2;
            CallExpression expression2;
            List arguments;
            int nextArg = this.state == 2 ? 0 : this.state - 3 + 1;
            if (nextArg < (arguments = (expression2 = (CallExpression)(typedGoal2 = (ExpressionTypeGoal)this.goal).getExpression()).getArgs().getExpressions()).size()) {
                this.state = 3 + nextArg;
                return new ExpressionTypeGoal(this.goal.getContext(), (ASTNode)arguments.get(nextArg));
            }
            this.state = 10000;
        }
        if (this.state == 10000) {
            ExpressionTypeGoal typedGoal3 = (ExpressionTypeGoal)this.goal;
            expression = (CallExpression)typedGoal3.getExpression();
            this.state = 10001;
            if (this.receiverType == UnknownType.INSTANCE) {
                this.receiverType = null;
            }
            return new MethodReturnTypeGoal(new InstanceContext((ISourceModuleContext)this.goal.getContext(), this.receiverType), expression.getName(), this.arguments);
        }
        if (this.state == 10001) {
            this.result = (IEvaluatedType)previousResult;
            this.state = -2;
        }
        return null;
    }

    public Object produceResult() {
        if (this.state == -1) {
            return null;
        }
        return this.result;
    }

    public IGoal[] init() {
        IGoal goal = this.produceNextSubgoal(null, null);
        if (goal != null) {
            return new IGoal[]{goal};
        }
        return IGoal.NO_GOALS;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        IGoal goal = this.produceNextSubgoal(subgoal, result);
        if (goal != null) {
            return new IGoal[]{goal};
        }
        return IGoal.NO_GOALS;
    }
}

