/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.io.File;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersUpdater;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public abstract class InterpreterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InterpretersBlock fInterpretersBlock;

    public InterpreterPreferencePage() {
        this.setTitle(InterpretersMessages.InterpretersPreferencePage_1);
        this.setDescription(InterpretersMessages.InterpretersPreferencePage_2);
    }

    public void init(IWorkbench workbench) {
    }

    public abstract InterpretersBlock createInterpretersBlock();

    private void initDefaultInterpreter() {
        IInterpreterInstall realDefault = ScriptRuntime.getDefaultInterpreterInstall((String)this.fInterpretersBlock.getCurrentNature());
        boolean verified = false;
        if (realDefault != null) {
            IInterpreterInstall[] Interpreters = this.fInterpretersBlock.getInterpreters();
            int i = 0;
            while (i < Interpreters.length) {
                IInterpreterInstall fakeInterpreter = Interpreters[i];
                if (fakeInterpreter.equals(realDefault)) {
                    verified = true;
                    this.verifyDefaultInterpreter(fakeInterpreter);
                    break;
                }
                ++i;
            }
        }
        if (!verified) {
            if (this.fInterpretersBlock.getInterpreters().length > 0) {
                this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_pleaseSetDefaultInterpreter);
            } else {
                this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_addInterpreter);
            }
        }
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        this.fInterpretersBlock = this.createInterpretersBlock();
        this.fInterpretersBlock.createControl(ancestor);
        Control control = this.fInterpretersBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fInterpretersBlock.restoreColumnSettings(DLTKDebugUIPlugin.getDefault().getDialogSettings(), "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ancestor, "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        this.initDefaultInterpreter();
        this.fInterpretersBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IInterpreterInstall install = InterpreterPreferencePage.this.getCurrentDefaultInterpreter();
                if (install == null) {
                    if (InterpreterPreferencePage.this.fInterpretersBlock.getInterpreters().length > 0) {
                        InterpreterPreferencePage.this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_pleaseSetDefaultInterpreter);
                    } else {
                        InterpreterPreferencePage.this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_addInterpreter);
                    }
                } else {
                    InterpreterPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        final boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                IInterpreterInstall defaultInterpreter = InterpreterPreferencePage.this.getCurrentDefaultInterpreter();
                IInterpreterInstall[] Interpreters = InterpreterPreferencePage.this.fInterpretersBlock.getInterpreters();
                InterpretersUpdater updater = new InterpretersUpdater();
                if (!updater.updateInterpreterSettings(InterpreterPreferencePage.this.fInterpretersBlock.getCurrentNature(), Interpreters, defaultInterpreter)) {
                    canceled[0] = true;
                }
            }
        });
        if (canceled[0]) {
            return false;
        }
        IDialogSettings settings = DLTKDebugUIPlugin.getDefault().getDialogSettings();
        this.fInterpretersBlock.saveColumnSettings(settings, "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        return super.performOk();
    }

    protected IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyDefaultInterpreter(IInterpreterInstall Interpreter) {
        if (Interpreter == null) {
            this.fInterpretersBlock.setCheckedInterpreter(null);
            return;
        }
        LibraryLocation[] locations = ScriptRuntime.getLibraryLocations((IInterpreterInstall)Interpreter);
        boolean exist = true;
        int i = 0;
        while (i < locations.length) {
            exist = exist && new File(locations[i].getLibraryPath().toOSString()).exists();
            ++i;
        }
        if (exist) {
            this.fInterpretersBlock.setCheckedInterpreter(Interpreter);
            return;
        }
        this.fInterpretersBlock.removeInterpreters(new IInterpreterInstall[]{Interpreter});
        IInterpreterInstall def = null;
        def = ScriptRuntime.getDefaultInterpreterInstall((String)this.fInterpretersBlock.getCurrentNature());
        if (def == null) {
            this.fInterpretersBlock.setCheckedInterpreter(null);
        } else {
            this.fInterpretersBlock.setCheckedInterpreter(def);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)InterpretersMessages.InterpretersPreferencePage_1, (String)InterpretersMessages.InterpretersPreferencePage_10, (IStatus)new Status(4, "org.eclipse.dltk.debug.ui", 0, InterpretersMessages.InterpretersPreferencePage_11, null));
    }

    private IInterpreterInstall getCurrentDefaultInterpreter() {
        return this.fInterpretersBlock.getCheckedInterpreter();
    }
}

