/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.launching.CompositeId;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.DefaultEntryResolver;
import org.eclipse.dltk.internal.launching.DefaultProjectBuildpathEntry;
import org.eclipse.dltk.internal.launching.InterpreterContainerInitializer;
import org.eclipse.dltk.internal.launching.InterpreterDefinitionsContainer;
import org.eclipse.dltk.internal.launching.ListenerList;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathEntry;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathEntryResolver;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathProvider;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry2;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntryResolver;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntryResolver2;
import org.eclipse.dltk.launching.IRuntimeBuildpathProvider;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptLaunchConfigurationConstants;
import org.eclipse.dltk.launching.StandardBuildpathProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ScriptRuntime {
    public static final String INTERPRETER_CONTAINER = String.valueOf(DLTKLaunchingPlugin.getUniqueIdentifier()) + ".INTERPRETER_CONTAINER";
    public static final String EXTENSION_POINT_RUNTIME_BUILDPATH_ENTRY_RESOLVERS = "runtimeBuildpathEntryResolvers";
    public static final String EXTENSION_POINT_RUNTIME_BUILDPATH_PROVIDERS = "buildpathProviders";
    public static final String EXTENSION_POINT_INTERPRETER_INSTALLS = "interpreterInstalls";
    public static final int ERR_UNABLE_TO_RESOLVE_INTERPRETER = 160;
    public static final String PREF_CONNECT_TIMEOUT = String.valueOf(DLTKLaunchingPlugin.getUniqueIdentifier()) + ".PREF_CONNECT_TIMEOUT";
    public static final String PREF_INTERPRETER_XML = String.valueOf(DLTKLaunchingPlugin.getUniqueIdentifier()) + ".PREF_INTERPRETER_XML";
    public static final int DEF_CONNECT_TIMEOUT = 20000;
    public static final String BUILDPATH_ATTR_LIBRARY_PATH_ENTRY = String.valueOf(DLTKLaunchingPlugin.getUniqueIdentifier()) + ".CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
    private static Object fgInterpreterLock = new Object();
    private static boolean fgInitializingInterpreters = false;
    private static IInterpreterInstallType[] fgInterpreterTypes = null;
    private static Map fgDefaultInterpreterId = new HashMap();
    private static Map fgDefaultInterpreterConnectorId = new HashMap();
    private static Map fgContainerResolvers = null;
    private static Map fgRuntimeBuildpathEntryResolvers = null;
    private static Map fgPathProviders = null;
    private static IRuntimeBuildpathProvider fgDefaultBuildpathProvider = new StandardBuildpathProvider();
    private static ListenerList fgInterpreterListeners = new ListenerList(5);
    private static ThreadLocal fgProjects = new ThreadLocal();
    private static ThreadLocal fgEntryCount = new ThreadLocal();
    private static Set fgContributedInterpreters = new HashSet();

    private ScriptRuntime() {
    }

    private static void initializeInterpreterTypeExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.launching", "interpreterInstallTypes");
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(DLTKLaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.ScriptRuntime_exceptionsOccurred, null);
        fgInterpreterTypes = new IInterpreterInstallType[configs.length];
        int i = 0;
        while (i < configs.length) {
            try {
                IInterpreterInstallType installType;
                ScriptRuntime.fgInterpreterTypes[i] = installType = (IInterpreterInstallType)configs[i].createExecutableExtension("class");
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            DLTKLaunchingPlugin.log((IStatus)status);
            ArrayList<IInterpreterInstallType> temp = new ArrayList<IInterpreterInstallType>(fgInterpreterTypes.length);
            int i2 = 0;
            while (i2 < fgInterpreterTypes.length) {
                if (fgInterpreterTypes[i2] != null) {
                    temp.add(fgInterpreterTypes[i2]);
                }
                fgInterpreterTypes = new IInterpreterInstallType[temp.size()];
                fgInterpreterTypes = temp.toArray(fgInterpreterTypes);
                ++i2;
            }
        }
    }

    private static String getNatureFromProject(IScriptProject project) {
        try {
            return DLTKLanguageManager.getLanguageToolkit((IModelElement)project).getNatureId();
        }
        catch (Exception e) {
            DLTKLaunchingPlugin.log(e);
            return null;
        }
    }

    public static IInterpreterInstall getInterpreterInstall(IScriptProject project) throws CoreException {
        IInterpreterInstall interpreter = null;
        IBuildpathEntry[] buildpath = project.getRawBuildpath();
        int i = 0;
        while (i < buildpath.length) {
            IBuildpathEntry entry = buildpath[i];
            switch (entry.getEntryKind()) {
                case 5: {
                    IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    interpreter = resolver.resolveInterpreterInstall(ScriptRuntime.getNatureFromProject(project), entry);
                }
            }
            if (interpreter != null) {
                return interpreter;
            }
            ++i;
        }
        return null;
    }

    public static IInterpreterInstallType getInterpreterInstallType(String id) {
        IInterpreterInstallType[] installTypes = ScriptRuntime.getInterpreterInstallTypes();
        if (installTypes == null) {
            return null;
        }
        int i = 0;
        while (i < installTypes.length) {
            IInterpreterInstallType type = installTypes[i];
            if (type != null && type.getId().equals(id)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static void setDefaultInterpreterInstall(IInterpreterInstall interpreter, IProgressMonitor monitor) throws CoreException {
        ScriptRuntime.setDefaultInterpreterInstall(interpreter, monitor, true);
    }

    public static void setDefaultInterpreterInstall(IInterpreterInstall interpreter, IProgressMonitor monitor, boolean savePreference) throws CoreException {
        IInterpreterInstall previous = null;
        String nature = interpreter.getInterpreterInstallType().getNatureId();
        if (fgDefaultInterpreterId.get(nature) != null) {
            previous = ScriptRuntime.getInterpreterFromCompositeId((String)fgDefaultInterpreterId.get(nature));
        }
        fgDefaultInterpreterId.put(nature, ScriptRuntime.getCompositeIdFromInterpreter(interpreter));
        if (savePreference) {
            ScriptRuntime.saveInterpreterConfiguration();
        }
        IInterpreterInstall current = null;
        if (fgDefaultInterpreterId.get(nature) != null) {
            current = ScriptRuntime.getInterpreterFromCompositeId((String)fgDefaultInterpreterId.get(nature));
        }
        if (previous != current) {
            ScriptRuntime.notifyDefaultInterpreterChanged(previous, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IInterpreterInstall getDefaultInterpreterInstall(String natureId) {
        IInterpreterInstall install = ScriptRuntime.getInterpreterFromCompositeId(ScriptRuntime.getDefaultInterpreterId(natureId));
        if (install != null && install.getInstallLocation().exists()) {
            return install;
        }
        if (install != null) {
            install.getInterpreterInstallType().disposeInterpreterInstall(install.getId());
        }
        Object object = fgInterpreterLock;
        synchronized (object) {
            fgDefaultInterpreterId.clear();
            fgInterpreterTypes = null;
            ScriptRuntime.initializeInterpreters();
        }
        return ScriptRuntime.getInterpreterFromCompositeId(ScriptRuntime.getDefaultInterpreterId(natureId));
    }

    public static IInterpreterInstallType[] getInterpreterInstallTypes() {
        ScriptRuntime.initializeInterpreters();
        return fgInterpreterTypes;
    }

    public static IInterpreterInstallType[] getInterpreterInstallTypes(String nature) {
        ScriptRuntime.initializeInterpreters();
        ArrayList<IInterpreterInstallType> res = new ArrayList<IInterpreterInstallType>();
        int i = 0;
        while (i < fgInterpreterTypes.length) {
            IInterpreterInstallType t = fgInterpreterTypes[i];
            if (t.getNatureId().equals(nature)) {
                res.add(t);
            }
            ++i;
        }
        return res.toArray(new IInterpreterInstallType[res.size()]);
    }

    public static String[] getInterpreterNatures() {
        Set set = fgDefaultInterpreterId.keySet();
        return set.toArray(new String[set.size()]);
    }

    private static String getDefaultInterpreterId(String nature) {
        ScriptRuntime.initializeInterpreters();
        return (String)fgDefaultInterpreterId.get(nature);
    }

    private static String getDefaultInterpreterConnectorId(String nature) {
        ScriptRuntime.initializeInterpreters();
        return (String)fgDefaultInterpreterConnectorId.get(nature);
    }

    public static String getCompositeIdFromInterpreter(IInterpreterInstall Interpreter) {
        if (Interpreter == null) {
            return null;
        }
        IInterpreterInstallType InterpreterType = Interpreter.getInterpreterInstallType();
        String typeID = InterpreterType.getId();
        CompositeId id = new CompositeId(new String[]{typeID, Interpreter.getId()});
        return id.toString();
    }

    public static IInterpreterInstall getInterpreterFromCompositeId(String idString) {
        IInterpreterInstallType InterpreterType;
        if (idString == null || idString.length() == 0) {
            return null;
        }
        CompositeId id = CompositeId.fromString(idString);
        if (id.getPartCount() == 2 && (InterpreterType = ScriptRuntime.getInterpreterInstallType(id.get(0))) != null) {
            return InterpreterType.findInterpreterInstall(id.get(1));
        }
        return null;
    }

    public static IScriptProject getScriptProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("project", null);
        if (projectName == null || projectName.trim().length() < 1) {
            return null;
        }
        IScriptProject scriptProject = ScriptRuntime.getScriptModel().getScriptProject(projectName);
        if (scriptProject != null && scriptProject.getProject().exists() && !scriptProject.getProject().isOpen()) {
            ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_28, (Object[])new String[]{configuration.getName(), projectName}), 101, null);
        }
        if (scriptProject == null || !scriptProject.exists()) {
            ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Launch_configuration__0__references_non_existing_project__1___1, (Object[])new String[]{configuration.getName(), projectName}), 102, null);
        }
        return scriptProject;
    }

    private static IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    public static IInterpreterInstall computeInterpreterInstall(ILaunchConfiguration configuration) throws CoreException {
        IInterpreterInstall res;
        String nature = configuration.getAttribute("nature", null);
        String containerPath = configuration.getAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, null);
        if (containerPath == null) {
            IInterpreterInstall install;
            IScriptProject proj = ScriptRuntime.getScriptProject(configuration);
            if (proj != null && (install = ScriptRuntime.getInterpreterInstall(proj)) != null) {
                return install;
            }
        } else {
            IPath interpreterPath = Path.fromPortableString((String)containerPath);
            IBuildpathEntry entry = DLTKCore.newContainerEntry((IPath)interpreterPath);
            IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(interpreterPath.segment(0));
            if (resolver != null) {
                return resolver.resolveInterpreterInstall(nature, entry);
            }
            resolver = ScriptRuntime.getContainerResolver(interpreterPath.segment(0));
            if (resolver != null) {
                return resolver.resolveInterpreterInstall(nature, entry);
            }
        }
        if (nature == null) {
            ScriptRuntime.abort(LaunchingMessages.ScriptRuntime_notDefaultInterpreter, 167, null);
        }
        if ((res = ScriptRuntime.getDefaultInterpreterInstall(nature)) == null) {
            ScriptRuntime.abort(LaunchingMessages.ScriptRuntime_notDefaultInterpreter, 167, null);
        }
        return res;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        ScriptRuntime.abort(message, 100, exception);
    }

    private static void abort(String message, int code, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static void saveInterpreterConfiguration() throws CoreException {
        if (fgInterpreterTypes == null) {
            return;
        }
        try {
            String xml = ScriptRuntime.getInterpretersAsXML();
            ScriptRuntime.getPreferences().setValue(PREF_INTERPRETER_XML, xml);
            ScriptRuntime.savePreferences();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.ScriptRuntime_exceptionsOccurred, (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.ScriptRuntime_exceptionsOccurred, (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.ScriptRuntime_exceptionsOccurred, (Throwable)e));
        }
    }

    private static String getInterpretersAsXML() throws IOException, ParserConfigurationException, TransformerException {
        InterpreterDefinitionsContainer container = new InterpreterDefinitionsContainer();
        String[] natures = ScriptRuntime.getInterpreterNatures();
        int i = 0;
        while (i < natures.length) {
            String id = ScriptRuntime.getDefaultInterpreterId(natures[i]);
            if (id != null) {
                container.setDefaultInterpreterInstallCompositeID(natures[i], id);
            }
            if ((id = ScriptRuntime.getDefaultInterpreterConnectorId(natures[i])) != null) {
                container.setDefaultInterpreterInstallConnectorTypeID(natures[i], id);
            }
            ++i;
        }
        IInterpreterInstallType[] InterpreterTypes = ScriptRuntime.getInterpreterInstallTypes();
        int i2 = 0;
        while (i2 < InterpreterTypes.length) {
            IInterpreterInstall[] Interpreters = InterpreterTypes[i2].getInterpreterInstalls();
            int j = 0;
            while (j < Interpreters.length) {
                IInterpreterInstall install = Interpreters[j];
                container.addInterpreter(install);
                ++j;
            }
            ++i2;
        }
        return container.getAsXML();
    }

    private static boolean addPersistedInterpreters(InterpreterDefinitionsContainer interpreterDefs) throws IOException {
        String InterpreterXMLString = ScriptRuntime.getPreferences().getString(PREF_INTERPRETER_XML);
        if (InterpreterXMLString.length() > 0) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(InterpreterXMLString.getBytes());
                InterpreterDefinitionsContainer.parseXMLIntoContainer(inputStream, interpreterDefs);
                return false;
            }
            catch (IOException ioe) {
                DLTKLaunchingPlugin.log(ioe);
            }
        } else {
            IPath stateLocation = DLTKLaunchingPlugin.getDefault().getStateLocation();
            IPath stateFile = stateLocation.append("interpreterConfiguration.xml");
            File file = new File(stateFile.toOSString());
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                InterpreterDefinitionsContainer.parseXMLIntoContainer(fileInputStream, interpreterDefs);
            }
        }
        return true;
    }

    private static String substitute(String expression) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
    }

    public static boolean isContributedInterpreterInstall(String id) {
        ScriptRuntime.getInterpreterInstallTypes();
        return fgContributedInterpreters.contains(id);
    }

    public static LibraryLocation[] getLibraryLocations(IInterpreterInstall interperterInstall) {
        LibraryLocation[] locations = interperterInstall.getLibraryLocations();
        if (locations != null) {
            return locations;
        }
        LibraryLocation[] defaultLocations = interperterInstall.getInterpreterInstallType().getDefaultLibraryLocations(interperterInstall.getInstallLocation());
        ArrayList<LibraryLocation> existingDefaultLocations = new ArrayList<LibraryLocation>();
        int i = 0;
        while (i < defaultLocations.length) {
            LibraryLocation location = defaultLocations[i];
            File file = location.getLibraryPath().toFile();
            if (file.exists()) {
                existingDefaultLocations.add(location);
            }
            ++i;
        }
        return existingDefaultLocations.toArray(new LibraryLocation[existingDefaultLocations.size()]);
    }

    public static IBuildpathEntry getDefaultInterpreterContainerEntry() {
        return DLTKCore.newContainerEntry((IPath)ScriptRuntime.newDefaultInterpreterContainerPath());
    }

    public static IPath newDefaultInterpreterContainerPath() {
        return new Path(INTERPRETER_CONTAINER);
    }

    public static IPath newInterpreterContainerPath(IInterpreterInstall Interpreter) {
        return ScriptRuntime.newInterpreterContainerPath(Interpreter.getInterpreterInstallType().getId(), Interpreter.getName());
    }

    public static IPath newInterpreterContainerPath(String typeId, String name) {
        IPath path = ScriptRuntime.newDefaultInterpreterContainerPath();
        path = path.append(typeId);
        path = path.append(name);
        return path;
    }

    public static IInterpreterInstall getInterpreterInstall(String nature, IPath InterpreterEnvironmentContainerPath) {
        try {
            return InterpreterContainerInitializer.resolveInterpreter(nature, InterpreterEnvironmentContainerPath);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String getInterpreterInstallTypeId(IPath InterpreterEnvironmentContainerPath) {
        return InterpreterContainerInitializer.getInterpreterTypeId(InterpreterEnvironmentContainerPath);
    }

    public static String getInterpreterInstallName(IPath InterpreterEnvironmentContainerPath) {
        return InterpreterContainerInitializer.getInterpreterName(InterpreterEnvironmentContainerPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRuntimeBuildpathEntry computeInterpreterEntry(ILaunchConfiguration configuration) throws CoreException {
        String containerAttr = configuration.getAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, null);
        IPath containerPath = null;
        if (containerAttr == null) {
            IScriptProject proj = ScriptRuntime.getScriptProject(configuration);
            if (proj != null) return ScriptRuntime.computeInterpreterEntry(proj);
            containerPath = ScriptRuntime.newDefaultInterpreterContainerPath();
        } else {
            containerPath = Path.fromPortableString((String)containerAttr);
        }
        if (containerPath == null) return null;
        return ScriptRuntime.newRuntimeContainerBuildpathEntry(containerPath, 1);
    }

    public static IRuntimeBuildpathEntry computeInterpreterEntry(IScriptProject project) throws CoreException {
        IBuildpathEntry[] rawBuildpath = project.getRawBuildpath();
        IRuntimeBuildpathEntryResolver2 resolver = null;
        int i = 0;
        while (i < rawBuildpath.length) {
            IBuildpathEntry entry = rawBuildpath[i];
            block0 : switch (entry.getEntryKind()) {
                case 5: {
                    IBuildpathContainer container;
                    resolver = ScriptRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isInterpreterInstallReference(ScriptRuntime.getNatureFromProject(project), entry) || (container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project)) == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            return ScriptRuntime.newRuntimeContainerBuildpathEntry(entry.getPath(), 1);
                        }
                        case 2: {
                            return ScriptRuntime.newRuntimeContainerBuildpathEntry(entry.getPath(), 2);
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean isInterpreterInstallReference(String lang, IRuntimeBuildpathEntry entry) {
        IBuildpathEntry buildpathEntry = entry.getBuildpathEntry();
        if (buildpathEntry != null) {
            switch (buildpathEntry.getEntryKind()) {
                case 5: {
                    IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(buildpathEntry.getPath().segment(0));
                    if (resolver == null) break;
                    return resolver.isInterpreterInstallReference(lang, buildpathEntry);
                }
            }
        }
        return false;
    }

    public static void addInterpreterInstallChangedListener(IInterpreterInstallChangedListener listener) {
        fgInterpreterListeners.add(listener);
    }

    public static void removeInterpreterInstallChangedListener(IInterpreterInstallChangedListener listener) {
        fgInterpreterListeners.remove(listener);
    }

    private static void notifyDefaultInterpreterChanged(IInterpreterInstall previous, IInterpreterInstall current) {
        Object[] listeners = fgInterpreterListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IInterpreterInstallChangedListener listener = (IInterpreterInstallChangedListener)listeners[i];
            listener.defaultInterpreterInstallChanged(previous, current);
            ++i;
        }
    }

    public static void fireInterpreterChanged(PropertyChangeEvent event) {
        Object[] listeners = fgInterpreterListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IInterpreterInstallChangedListener listener = (IInterpreterInstallChangedListener)listeners[i];
            listener.interpreterChanged(event);
            ++i;
        }
    }

    public static void fireInterpreterAdded(IInterpreterInstall Interpreter) {
        if (!fgInitializingInterpreters) {
            Object[] listeners = fgInterpreterListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IInterpreterInstallChangedListener listener = (IInterpreterInstallChangedListener)listeners[i];
                listener.interpreterAdded(Interpreter);
                ++i;
            }
        }
    }

    public static void fireInterpreterRemoved(IInterpreterInstall Interpreter) {
        Object[] listeners = fgInterpreterListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IInterpreterInstallChangedListener listener = (IInterpreterInstallChangedListener)listeners[i];
            listener.interpreterRemoved(Interpreter);
            ++i;
        }
    }

    public static Preferences getPreferences() {
        return DLTKLaunchingPlugin.getDefault().getPluginPreferences();
    }

    public static void savePreferences() {
        DLTKLaunchingPlugin.getDefault().savePluginPreferences();
    }

    public static void addContainerResolver(IRuntimeBuildpathEntryResolver resolver, String containerIdentifier) {
        Map map = ScriptRuntime.getContainerResolvers();
        map.put(containerIdentifier, resolver);
    }

    private static Map getContainerResolvers() {
        if (fgContainerResolvers == null) {
            ScriptRuntime.initializeResolvers();
        }
        return fgContainerResolvers;
    }

    private static void initializeResolvers() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.launching", EXTENSION_POINT_RUNTIME_BUILDPATH_ENTRY_RESOLVERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgContainerResolvers = new HashMap(extensions.length);
        fgRuntimeBuildpathEntryResolvers = new HashMap(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeBuildpathEntryResolver res = new RuntimeBuildpathEntryResolver(extensions[i]);
            String container = res.getContainerId();
            String entryId = res.getRuntimeBuildpathEntryId();
            if (container != null) {
                fgContainerResolvers.put(container, res);
            }
            if (entryId != null) {
                fgRuntimeBuildpathEntryResolvers.put(entryId, res);
            }
            ++i;
        }
    }

    private static Map getBuildpathProviders() {
        if (fgPathProviders == null) {
            ScriptRuntime.initializeProviders();
        }
        return fgPathProviders;
    }

    private static void initializeProviders() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.launching", EXTENSION_POINT_RUNTIME_BUILDPATH_PROVIDERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgPathProviders = new HashMap(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeBuildpathProvider res = new RuntimeBuildpathProvider(extensions[i]);
            fgPathProviders.put(res.getIdentifier(), res);
            ++i;
        }
    }

    private static IRuntimeBuildpathEntryResolver2 getContainerResolver(String containerId) {
        return (IRuntimeBuildpathEntryResolver2)ScriptRuntime.getContainerResolvers().get(containerId);
    }

    public static String[] computeScriptLibraryPath(IScriptProject project, boolean requiredProjects) throws CoreException {
        HashSet visited = new HashSet();
        ArrayList entries = new ArrayList();
        ScriptRuntime.gatherScriptLibraryPathEntries(project, requiredProjects, visited, entries);
        ArrayList<String> resolved = new ArrayList<String>(entries.size());
        Iterator iterator = entries.iterator();
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        while (iterator.hasNext()) {
            IPath location;
            String entry = (String)iterator.next();
            String resolvedEntry = manager.performStringSubstitution(entry);
            Path path = new Path(resolvedEntry);
            if (path.isAbsolute()) {
                File file = path.toFile();
                resolved.add(file.getAbsolutePath());
                continue;
            }
            IResource resource = root.findMember((IPath)path);
            if (resource == null || (location = resource.getLocation()) == null) continue;
            resolved.add(location.toFile().getAbsolutePath());
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    private static void gatherScriptLibraryPathEntries(IScriptProject project, boolean requiredProjects, Set visited, List entries) throws CoreException {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IBuildpathEntry[] rawBuildpath = project.getRawBuildpath();
        IBuildpathEntry[] required = ScriptRuntime.processScriptLibraryPathEntries(project, requiredProjects, rawBuildpath, entries);
        if (required != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < required.length) {
                IScriptProject requiredProject;
                IBuildpathEntry entry = required[i];
                String projectName = entry.getPath().segment(0);
                IProject p = root.getProject(projectName);
                if (p.exists() && (requiredProject = DLTKCore.create((IProject)p)) != null) {
                    ScriptRuntime.gatherScriptLibraryPathEntries(requiredProject, requiredProjects, visited, entries);
                }
                ++i;
            }
        }
    }

    private static IBuildpathEntry[] processScriptLibraryPathEntries(IScriptProject project, boolean collectRequired, IBuildpathEntry[] buildpathEntries, List entries) throws CoreException {
        ArrayList<IBuildpathEntry> req = null;
        int i = 0;
        while (i < buildpathEntries.length) {
            IBuildpathEntry entry = buildpathEntries[i];
            IBuildpathAttribute[] extraAttributes = entry.getExtraAttributes();
            int j = 0;
            while (j < extraAttributes.length) {
                String[] paths = ScriptRuntime.getLibraryPaths(extraAttributes[j]);
                if (paths != null) {
                    int k = 0;
                    while (k < paths.length) {
                        entries.add(paths[k]);
                        ++k;
                    }
                }
                ++j;
            }
            if (entry.getEntryKind() == 5) {
                IBuildpathEntry[] requiredProjects;
                IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project);
                if (container != null && (requiredProjects = ScriptRuntime.processScriptLibraryPathEntries(project, collectRequired, container.getBuildpathEntries(), entries)) != null) {
                    if (req == null) {
                        req = new ArrayList();
                    }
                    int j2 = 0;
                    while (j2 < requiredProjects.length) {
                        req.add(requiredProjects[j2]);
                        ++j2;
                    }
                }
            } else if (collectRequired && entry.getEntryKind() == 2) {
                if (req == null) {
                    req = new ArrayList<IBuildpathEntry>();
                }
                req.add(entry);
            }
            ++i;
        }
        if (req != null) {
            return req.toArray(new IBuildpathEntry[req.size()]);
        }
        return null;
    }

    public static IBuildpathAttribute newLibraryPathsAttribute(String[] paths) {
        StringBuffer value = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            value.append(paths[i]);
            if (i < paths.length - 1) {
                value.append("|");
            }
            ++i;
        }
        return DLTKCore.newBuildpathAttribute((String)BUILDPATH_ATTR_LIBRARY_PATH_ENTRY, (String)value.toString());
    }

    public static String[] getLibraryPaths(IBuildpathAttribute attribute) {
        if (BUILDPATH_ATTR_LIBRARY_PATH_ENTRY.equals(attribute.getName())) {
            String value = attribute.getValue();
            return value.split("\\|");
        }
        return null;
    }

    private static void addInterpreterExtensions(InterpreterDefinitionsContainer InterpreterDefs) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.launching", EXTENSION_POINT_INTERPRETER_INSTALLS);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            block18: {
                IConfigurationElement element = configs[i];
                try {
                    if ("interpreterInstall".equals(element.getName())) {
                        IInterpreterInstall install;
                        IInterpreterInstallType installType;
                        String id;
                        String InterpreterType = element.getAttribute("interpreterInstallType");
                        if (InterpreterType == null) {
                            ScriptRuntime.abort(MessageFormat.format((String)"Missing required interpreterInstallType attribute for interpreterInstall contributed by {0}", (Object[])new String[]{element.getContributor().getName()}), null);
                        }
                        if ((id = element.getAttribute("id")) == null) {
                            ScriptRuntime.abort(MessageFormat.format((String)"Missing required id attribute for interpreterInstall contributed by {0}", (Object[])new String[]{element.getContributor().getName()}), null);
                        }
                        if ((installType = ScriptRuntime.getInterpreterInstallType(InterpreterType)) == null) {
                            ScriptRuntime.abort(MessageFormat.format((String)"InterpreterInstall {0} contributed by {1} references undefined Interpreter install type {2}", (Object[])new String[]{id, element.getContributor().getName(), InterpreterType}), null);
                        }
                        if ((install = installType.findInterpreterInstall(id)) == null) {
                            IStatus status;
                            String home;
                            String name = element.getAttribute("name");
                            if (name == null) {
                                ScriptRuntime.abort(MessageFormat.format((String)"interpreterInstall {0} contributed by {1} missing required attribute name", (Object[])new String[]{id, element.getContributor().getName()}), null);
                            }
                            if ((home = element.getAttribute("home")) == null) {
                                ScriptRuntime.abort(MessageFormat.format((String)"interpreterInstall {0} contributed by {1} missing required attribute home", (Object[])new String[]{id, element.getContributor().getName()}), null);
                            }
                            String InterpreterArgs = element.getAttribute("interpreterArgs");
                            InterpreterStandin standin = new InterpreterStandin(installType, id);
                            standin.setName(name);
                            home = ScriptRuntime.substitute(home);
                            File homeDir = new File(home);
                            if (homeDir.exists()) {
                                try {
                                    home = homeDir.getCanonicalPath();
                                    homeDir = new File(home);
                                }
                                catch (IOException iOException) {}
                            }
                            if (!(status = installType.validateInstallLocation(homeDir)).isOK()) {
                                ScriptRuntime.abort(MessageFormat.format((String)"Illegal install location {0} for interpreterInstall {1} contributed by {2}: {3}", (Object[])new String[]{home, id, element.getContributor().getName(), status.getMessage()}), null);
                            }
                            standin.setInstallLocation(homeDir);
                            if (InterpreterArgs != null) {
                                standin.setInterpreterArgs(InterpreterArgs);
                            }
                            IConfigurationElement[] libraries = element.getChildren("library");
                            LibraryLocation[] locations = null;
                            if (libraries.length > 0) {
                                locations = new LibraryLocation[libraries.length];
                                int j = 0;
                                while (j < libraries.length) {
                                    IConfigurationElement library = libraries[j];
                                    String libPathStr = library.getAttribute("path");
                                    if (libPathStr == null) {
                                        ScriptRuntime.abort(MessageFormat.format((String)"library for interpreterInstall {0} contributed by {1} missing required attribute libPath", (Object[])new String[]{id, element.getContributor().getName()}), null);
                                    }
                                    Path homePath = new Path(home);
                                    IPath libPath = homePath.append(ScriptRuntime.substitute(libPathStr));
                                    locations[j] = new LibraryLocation(libPath);
                                    ++j;
                                }
                            }
                            standin.setLibraryLocations(locations);
                            InterpreterDefs.addInterpreter(standin);
                        }
                        fgContributedInterpreters.add(id);
                        break block18;
                    }
                    ScriptRuntime.abort(MessageFormat.format((String)"Illegal element {0} in InterpreterInstalls extension contributed by {1}", (Object[])new String[]{element.getName(), element.getContributor().getName()}), null);
                }
                catch (CoreException e) {
                    DLTKLaunchingPlugin.log(e);
                }
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private static void initializeInterpreters() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 302->312)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IRuntimeBuildpathEntry newDefaultProjectBuildpathEntry(IScriptProject project) {
        return new DefaultProjectBuildpathEntry(project);
    }

    public static IRuntimeBuildpathEntry newProjectRuntimeBuildpathEntry(IScriptProject project) {
        IBuildpathEntry cpe = DLTKCore.newProjectEntry((IPath)project.getProject().getFullPath());
        return ScriptRuntime.newRuntimeBuildpathEntry(cpe);
    }

    public static IRuntimeBuildpathEntry newArchiveRuntimeBuildpathEntry(IResource resource) {
        IBuildpathEntry cpe = DLTKCore.newLibraryEntry((IPath)resource.getFullPath());
        return ScriptRuntime.newRuntimeBuildpathEntry(cpe);
    }

    public static IRuntimeBuildpathEntry newArchiveRuntimeBuildpathEntry(IPath path) {
        IBuildpathEntry cpe = DLTKCore.newLibraryEntry((IPath)path);
        return ScriptRuntime.newRuntimeBuildpathEntry(cpe);
    }

    public static IRuntimeBuildpathEntry newRuntimeContainerBuildpathEntry(IPath path, int buildpathProperty) throws CoreException {
        return ScriptRuntime.newRuntimeContainerBuildpathEntry(path, buildpathProperty, null);
    }

    public static IRuntimeBuildpathEntry newRuntimeContainerBuildpathEntry(IPath path, int buildpathProperty, IScriptProject project) throws CoreException {
        IBuildpathEntry cpe = DLTKCore.newContainerEntry((IPath)path);
        RuntimeBuildpathEntry entry = new RuntimeBuildpathEntry(cpe, buildpathProperty);
        entry.setScriptProject(project);
        return entry;
    }

    public static IRuntimeBuildpathEntry newRuntimeBuildpathEntry(String memento) throws CoreException {
        try {
            Element root = null;
            DocumentBuilder parser = DLTKLaunchingPlugin.getParser();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String id = root.getAttribute("id");
            if (id == null || id.length() == 0) {
                return new RuntimeBuildpathEntry(root);
            }
            IRuntimeBuildpathEntry2 entry = DLTKLaunchingPlugin.getDefault().newRuntimeBuildpathEntry(id);
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Element element;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && "memento".equals((element = (Element)node).getNodeName())) {
                    entry.initializeFrom(element);
                }
                ++i;
            }
            return entry;
        }
        catch (SAXException e) {
            ScriptRuntime.abort(LaunchingMessages.ScriptRuntime_31, e);
        }
        catch (IOException e) {
            ScriptRuntime.abort(LaunchingMessages.ScriptRuntime_32, e);
        }
        return null;
    }

    private static IRuntimeBuildpathEntry newRuntimeBuildpathEntry(IBuildpathEntry entry) {
        return new RuntimeBuildpathEntry(entry);
    }

    public static IRuntimeBuildpathEntry[] computeUnresolvedRuntimeBuildpath(IScriptProject project) throws CoreException {
        IBuildpathEntry[] entries = project.getRawBuildpath();
        ArrayList<IRuntimeBuildpathEntry> buildpathEntries = new ArrayList<IRuntimeBuildpathEntry>(3);
        int i = 0;
        while (i < entries.length) {
            IBuildpathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 5: {
                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project);
                    if (container == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            buildpathEntries.add(ScriptRuntime.newRuntimeContainerBuildpathEntry(container.getPath(), 1, project));
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        buildpathEntries.add(ScriptRuntime.newDefaultProjectBuildpathEntry(project));
        return buildpathEntries.toArray(new IRuntimeBuildpathEntry[buildpathEntries.size()]);
    }

    public static IRuntimeBuildpathProvider getBuildpathProvider(ILaunchConfiguration configuration) throws CoreException {
        String providerId = configuration.getAttribute("buildpathProvider", null);
        IRuntimeBuildpathProvider provider = null;
        if (providerId == null) {
            provider = fgDefaultBuildpathProvider;
        } else {
            provider = (IRuntimeBuildpathProvider)ScriptRuntime.getBuildpathProviders().get(providerId);
            if (provider == null) {
                ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_26, (Object[])new String[]{providerId}), null);
            }
        }
        return provider;
    }

    private static IRuntimeBuildpathEntry[] computeDefaultContainerEntries(IRuntimeBuildpathEntry entry, ILaunchConfiguration config) throws CoreException {
        IScriptProject project = entry.getScriptProject();
        if (project == null) {
            project = ScriptRuntime.getScriptProject(config);
        }
        return ScriptRuntime.computeDefaultContainerEntries(entry, project);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IRuntimeBuildpathEntry[] computeDefaultContainerEntries(IRuntimeBuildpathEntry entry, IScriptProject project) throws CoreException {
        ArrayList<IRuntimeBuildpathEntry> resolved;
        int property;
        block22: {
            if (project == null) return new IRuntimeBuildpathEntry[0];
            if (entry == null) {
                return new IRuntimeBuildpathEntry[0];
            }
            IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project);
            if (container == null) {
                ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Could_not_resolve_classpath_container___0__1, (Object[])new String[]{entry.getPath().toString()}), null);
                return null;
            }
            IBuildpathEntry[] cpes = container.getBuildpathEntries();
            property = -1;
            switch (container.getKind()) {
                case 1: {
                    property = 3;
                    break;
                }
                case 3: {
                    property = 1;
                    break;
                }
                case 2: {
                    property = 2;
                    break;
                }
            }
            resolved = new ArrayList<IRuntimeBuildpathEntry>(cpes.length);
            ArrayList<IScriptProject> projects = (ArrayList<IScriptProject>)fgProjects.get();
            Integer count = (Integer)fgEntryCount.get();
            if (projects == null) {
                projects = new ArrayList<IScriptProject>();
                fgProjects.set(projects);
                count = new Integer(0);
            }
            int intCount = count;
            fgEntryCount.set(new Integer(++intCount));
            try {
                int i = 0;
                while (i < cpes.length) {
                    IBuildpathEntry cpe = cpes[i];
                    if (cpe.getEntryKind() == 2) {
                        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(cpe.getPath().segment(0));
                        IScriptProject jp = DLTKCore.create((IProject)p);
                        if (!projects.contains(jp)) {
                            projects.add(jp);
                            IRuntimeBuildpathEntry buildpath = ScriptRuntime.newDefaultProjectBuildpathEntry(jp);
                            IRuntimeBuildpathEntry[] entries = ScriptRuntime.resolveRuntimeBuildpathEntry(buildpath, jp);
                            int j = 0;
                            while (j < entries.length) {
                                IRuntimeBuildpathEntry e = entries[j];
                                if (!resolved.contains(e)) {
                                    resolved.add(entries[j]);
                                }
                                ++j;
                            }
                        }
                    } else {
                        IRuntimeBuildpathEntry e = ScriptRuntime.newRuntimeBuildpathEntry(cpe);
                        if (!resolved.contains(e)) {
                            resolved.add(e);
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                if (--intCount == 0) {
                    fgProjects.set(null);
                    fgEntryCount.set(null);
                    throw throwable;
                }
                fgEntryCount.set(new Integer(intCount));
                throw throwable;
            }
            {
                Object var17_21 = null;
                if (--intCount == 0) {
                    fgProjects.set(null);
                    fgEntryCount.set(null);
                    break block22;
                }
                fgEntryCount.set(new Integer(intCount));
            }
        }
        IRuntimeBuildpathEntry[] result = new IRuntimeBuildpathEntry[resolved.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (IRuntimeBuildpathEntry)resolved.get(i);
            result[i].setBuildpathProperty(property);
            ++i;
        }
        return result;
    }

    public static IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        switch (entry.getType()) {
            case 4: {
                IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(entry.getContainerName());
                if (resolver == null) {
                    return ScriptRuntime.computeDefaultContainerEntries(entry, configuration);
                }
                return resolver.resolveRuntimeBuildpathEntry(entry, configuration);
            }
            case 2: {
                File file;
                String location = entry.getLocation();
                if (location == null) {
                    ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Buildpath_references_non_existant_archive___0__4, (Object[])new String[]{entry.getPath().toString()}), null);
                }
                if ((file = new File(location)).exists()) break;
                ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Buildpath_references_non_existant_archive___0__4, (Object[])new String[]{entry.getPath().toString()}), null);
                break;
            }
            case 5: {
                IRuntimeBuildpathEntryResolver resolver = ScriptRuntime.getContributedResolver(((IRuntimeBuildpathEntry2)entry).getTypeId());
                return resolver.resolveRuntimeBuildpathEntry(entry, configuration);
            }
        }
        return new IRuntimeBuildpathEntry[]{entry};
    }

    public static IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, IScriptProject project) throws CoreException {
        switch (entry.getType()) {
            case 4: {
                IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(entry.getContainerName());
                if (resolver == null) {
                    return ScriptRuntime.computeDefaultContainerEntries(entry, project);
                }
                return resolver.resolveRuntimeBuildpathEntry(entry, project);
            }
            case 5: {
                IRuntimeBuildpathEntryResolver resolver = ScriptRuntime.getContributedResolver(((IRuntimeBuildpathEntry2)entry).getTypeId());
                return resolver.resolveRuntimeBuildpathEntry(entry, project);
            }
        }
        return new IRuntimeBuildpathEntry[]{entry};
    }

    public static IRuntimeBuildpathEntry[] computeUnresolvedRuntimeBuildpath(ILaunchConfiguration configuration) throws CoreException {
        return ScriptRuntime.getBuildpathProvider(configuration).computeUnresolvedBuildpath(configuration);
    }

    public static IRuntimeBuildpathEntry[] resolveRuntimeBuildpath(IRuntimeBuildpathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        return ScriptRuntime.getBuildpathProvider(configuration).resolveBuildpath(entries, configuration);
    }

    private static Map getEntryResolvers() {
        if (fgRuntimeBuildpathEntryResolvers == null) {
            ScriptRuntime.initializeResolvers();
        }
        return fgRuntimeBuildpathEntryResolvers;
    }

    private static IRuntimeBuildpathEntryResolver getContributedResolver(String typeId) {
        IRuntimeBuildpathEntryResolver resolver = (IRuntimeBuildpathEntryResolver)ScriptRuntime.getEntryResolvers().get(typeId);
        if (resolver == null) {
            return new DefaultEntryResolver();
        }
        return resolver;
    }

    public static String[] computeDefaultRuntimeClassPath(IScriptProject jproject) throws CoreException {
        IRuntimeBuildpathEntry[] unresolved = ScriptRuntime.computeUnresolvedRuntimeBuildpath(jproject);
        ArrayList<String> resolved = new ArrayList<String>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeBuildpathEntry entry = unresolved[i];
            if (entry.getBuildpathProperty() == 3) {
                IRuntimeBuildpathEntry[] entries = ScriptRuntime.resolveRuntimeBuildpathEntry(entry, jproject);
                int j = 0;
                while (j < entries.length) {
                    String location = entries[j].getLocation();
                    if (location != null) {
                        resolved.add(location);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resolved.toArray(new String[resolved.size()]);
    }
}

