/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.docs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ruby.internal.ui.RubyUI;
import org.eclipse.dltk.utils.DeployHelper;

public class RiHelper {
    private static final String DOC_TERMINATION_LINE = "DLTKDOCEND";
    private static RiHelper instance;
    private WeakHashMap cache = new WeakHashMap();
    private Process riProcess;
    private OutputStreamWriter writer;
    private BufferedReader reader;
    private BufferedReader errorReader;

    public static RiHelper getInstance() {
        if (instance == null) {
            instance = new RiHelper();
        }
        return instance;
    }

    protected static boolean isTerminated(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    protected synchronized void runRiProcess() throws CoreException, IOException {
        IInterpreterInstall install = ScriptLaunchUtil.getDefaultInterpreterInstall((String)"org.eclipse.dltk.ruby.core.nature");
        if (install == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        File script = DeployHelper.deploy((Plugin)RubyUI.getDefault(), (String)"support/").append("dltkri.rb").toFile();
        this.riProcess = ScriptLaunchUtil.runScriptWithInterpreter((String)install.getInstallLocation().getAbsolutePath(), (File)script, null, null, null);
        this.writer = new OutputStreamWriter(this.riProcess.getOutputStream());
        this.reader = new BufferedReader(new InputStreamReader(this.riProcess.getInputStream()));
        this.errorReader = new BufferedReader(new InputStreamReader(this.riProcess.getErrorStream()));
    }

    protected synchronized void destroyRiProcess() {
        if (this.riProcess != null) {
            this.riProcess.destroy();
            this.riProcess = null;
            this.cache.clear();
        }
    }

    protected String readStderr() throws IOException {
        StringBuffer sb = new StringBuffer();
        String errorLine = null;
        while ((errorLine = this.errorReader.readLine()) != null) {
            sb.append(errorLine);
            sb.append("\n");
        }
        String error = sb.toString().trim();
        return error.length() > 0 ? error : null;
    }

    protected String readStdout() throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = this.reader.readLine()) != null && !line.equals(DOC_TERMINATION_LINE)) {
            sb.append(line);
        }
        return sb.toString();
    }

    protected String loadRiDoc(String keyword) throws IOException {
        this.writer.write(String.valueOf(keyword) + "\n");
        this.writer.flush();
        return this.readStdout();
    }

    private boolean checkRiProcess() {
        if (this.riProcess == null || RiHelper.isTerminated(this.riProcess)) {
            try {
                this.runRiProcess();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    protected RiHelper() {
        ScriptRuntime.addInterpreterInstallChangedListener((IInterpreterInstallChangedListener)new IInterpreterInstallChangedListener(){

            public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
                RiHelper.this.destroyRiProcess();
            }

            public void interpreterAdded(IInterpreterInstall Interpreter) {
            }

            public void interpreterChanged(PropertyChangeEvent event) {
            }

            public void interpreterRemoved(IInterpreterInstall Interpreter) {
            }
        });
    }

    public synchronized String getDocFor(String keyword) {
        String doc = (String)this.cache.get(keyword);
        if (doc == null && this.checkRiProcess()) {
            try {
                doc = this.loadRiDoc(keyword);
                this.cache.put(keyword, doc);
            }
            catch (IOException iOException) {
                this.destroyRiProcess();
            }
        }
        return doc;
    }
}

