/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner.ui.dialogs;

import org.eclipse.actf.examples.adesigner.internal.Messages;
import org.eclipse.actf.ui.util.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class URLOpenDialog {
    private Shell _shell;
    private Text _urlText;
    private String _url = "";
    private int _returnCode = 0;

    public URLOpenDialog(Shell shell) {
        this._shell = new Shell(shell, 34912);
        this._shell.setLayout((Layout)new GridLayout());
    }

    private void createButtonControls() {
        Composite composite = new Composite((Composite)this._shell, 0);
        GridData gridData = new GridData(136);
        gridData.heightHint = 50;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 20;
        layout.marginWidth = 20;
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        Button okButton = new Button(composite, 8);
        okButton.setText(IDialogConstants.OK);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URLOpenDialog.this._returnCode = 1;
                URLOpenDialog.this._url = URLOpenDialog.this._urlText.getText();
                URLOpenDialog.this._shell.close();
            }
        });
        Button cancelButton = new Button(composite, 8);
        cancelButton.setText(IDialogConstants.CANCEL);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URLOpenDialog.this._returnCode = 0;
                URLOpenDialog.this._shell.close();
            }
        });
        Button openButton = new Button(composite, 8);
        openButton.setText(IDialogConstants.BROWSE);
        openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog openDialog = new FileDialog(URLOpenDialog.this._shell, 4096);
                String openFile = openDialog.open();
                if (openFile != null && !openFile.equals("")) {
                    URLOpenDialog.this._urlText.setText(openFile);
                }
            }
        });
        this._shell.setDefaultButton(okButton);
    }

    private void createSettingControls() {
        Composite composite = new Composite((Composite)this._shell, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        composite.setLayout((Layout)gridLayout1);
        Label infoLabel = new Label(composite, 0);
        infoLabel.setText(IDialogConstants.OPENFILE_INFO);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        infoLabel.setLayoutData((Object)gridData);
        Label label1 = new Label(composite, 0);
        label1.setText("URL: ");
        this._urlText = new Text(composite, 2052);
        this._urlText.setText("");
        gridData = new GridData();
        gridData.widthHint = 300;
        this._urlText.setLayoutData((Object)gridData);
    }

    public int open() {
        this._shell.setText(Messages.DialogOpenURL_Open_URL);
        this.createSettingControls();
        this.createButtonControls();
        this._shell.setSize(375, 150);
        this._shell.open();
        this._shell.setLocation(100, 100);
        Display display = this._shell.getDisplay();
        while (!this._shell.isDisposed() || !display.readAndDispatch()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._returnCode;
    }

    public String getUrl() {
        return this._url;
    }
}

