/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.MediaObjectImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;

class WMPNodeImpl
extends MediaObjectImpl {
    private final IDispatch controls;
    private final IDispatch settings;

    WMPNodeImpl(NodeImpl nodeImpl, IDispatch iDispatch, IDispatch iDispatch2) {
        super(nodeImpl, iDispatch);
        this.controls = iDispatch2;
        Object object = Helper.get(iDispatch, "settings");
        this.settings = object instanceof IDispatch ? (IDispatch)object : null;
    }

    private boolean execControls(String string) {
        try {
            this.controls.invoke0(string);
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    private boolean putSettings(String string, Object object) {
        if (this.settings == null) {
            return false;
        }
        try {
            this.settings.put(string, object);
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    private Object getSettings(String string) {
        if (this.settings == null) {
            return null;
        }
        return Helper.get(this.settings, string);
    }

    public boolean fastForward() {
        return this.execControls("fastForward");
    }

    public boolean fastReverse() {
        return this.execControls("fastReverse");
    }

    public double getCurrentPosition() {
        Object object = Helper.get(this.controls, "currentPosition");
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        return 0.0;
    }

    public boolean setCurrentPosition(double d) {
        Object object = Helper.get(this.inode, "currentPosition");
        if (object instanceof Double) {
            return this.putSettings("currentPosition", new Double(d));
        }
        if (object instanceof Float) {
            return this.putSettings("currentPosition", new Float((float)d));
        }
        if (object instanceof Integer) {
            return this.putSettings("currentPosition", new Integer((int)d));
        }
        return false;
    }

    public double getTotalLength() {
        Object object = Helper.get(this.inode, "Duration");
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        return 0.0;
    }

    public boolean nextTrack() {
        return this.execControls("next");
    }

    public boolean pauseMedia() {
        return this.execControls("pause");
    }

    public boolean playMedia() {
        return this.execControls("play");
    }

    public boolean previousTrack() {
        return this.execControls("previous");
    }

    public boolean stopMedia() {
        return this.execControls("stop");
    }

    public int getVolume() {
        Object object = this.getSettings("volume");
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        return n * 10 + 0;
    }

    public boolean muteMedia(boolean bl) {
        return this.putSettings("mute", bl);
    }

    public boolean setVolume(int n) {
        n = (n - 0) * 100 / 1000;
        return this.putSettings("volume", n);
    }

    public INodeExVideo.VideoState getCurrentState() {
        Object object = Helper.get(this.inode, "playState");
        if (object instanceof Integer) {
            int n = (Integer)object;
            switch (n) {
                case 0: {
                    return INodeExVideo.VideoState.STATE_UNKNOWN;
                }
                case 1: {
                    return INodeExVideo.VideoState.STATE_STOP;
                }
                case 2: {
                    return INodeExVideo.VideoState.STATE_PAUSE;
                }
                case 3: {
                    return INodeExVideo.VideoState.STATE_PLAY;
                }
                case 4: {
                    return INodeExVideo.VideoState.STATE_FASTFORWARD;
                }
                case 5: {
                    return INodeExVideo.VideoState.STATE_FASTREVERSE;
                }
                case 6: 
                case 7: {
                    return INodeExVideo.VideoState.STATE_WAITING;
                }
            }
            return INodeExVideo.VideoState.STATE_STOP;
        }
        return INodeExVideo.VideoState.STATE_UNKNOWN;
    }

    public boolean getMuteState() {
        Object object = this.getSettings("mute");
        if (!(object instanceof Boolean)) {
            return false;
        }
        return (Boolean)object;
    }

    public String getVideoURL() {
        Object object = Helper.get(this.inode, "FileName");
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }
}

