/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.config;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.actf.core.config.AbstractConfiguration;
import org.eclipse.actf.core.config.ConfigurationException;
import org.eclipse.actf.core.runtime.IRuntimeContext;
import org.eclipse.actf.core.runtime.RuntimeContextFactory;
import org.eclipse.actf.util.resources.ClassLoaderCache;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlConfiguration
extends AbstractConfiguration {
    static final long serialVersionUID = -6983580695767275023L;
    private static final char PATH_SEPARATOR = '.';
    private static final String ROOT_ELEMENT_NAME = "configuration";
    private static final String POOL_ELEMENT = "pool";
    private static final String ATTR_PROPERTY_NAME = "name";
    private static final String ATTR_CONTENT_TYPE = "type";
    private static final String TEXT_CONTENT = ".textContent.";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String POOL_ID = "id";
    private static final String ACTF_XML_PREFIX = "actf";
    private transient String _currentXmlFilePrefix;
    private transient HashMap _attributeMap = new HashMap();
    private transient Logger logger = Logger.getLogger("org.eclipse.actf.core");

    public void addConfigurationData(Object object) throws ConfigurationException {
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            HashSet<String> hashSet = new HashSet<String>();
            if (!this._configMap.isEmpty()) {
                hashSet.addAll(Arrays.asList(this.getModelTypes()));
            }
            this.parseXml(inputStream);
            String[] stringArray = this.getModelTypes();
            int n = 0;
            while (n < stringArray.length) {
                if (!hashSet.contains(stringArray[n])) {
                    this._currentXmlFilePrefix = stringArray[n];
                    this.parseXml(stringArray[n]);
                }
                ++n;
            }
            this._currentXmlFilePrefix = null;
        } else {
            super.addConfigurationData(object);
        }
    }

    protected Map addConfigurationData(Object object, Map map) throws ConfigurationException {
        this._configMap = map;
        this.addConfigurationData(object);
        return this._configMap;
    }

    public Map getAttributeMap() {
        return (Map)this._attributeMap.get(this.getSymbolPool());
    }

    private void parseXml(InputStream inputStream) throws ConfigurationException {
        if (inputStream != null) {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse(inputStream, (DefaultHandler)new ParserHandler());
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "SAXParseException caught while parsing file." + exception.getMessage(), exception);
                throw new ConfigurationException("Exception caught while trying to parse file." + exception.getMessage());
            }
        }
    }

    private void parseXml(String string) throws ConfigurationException {
        IRuntimeContext iRuntimeContext = RuntimeContextFactory.getInstance().getRuntimeContext();
        InputStream inputStream = iRuntimeContext.getResourceLocator().getResourceAsStream(string, null, "xml", null);
        if (inputStream != null) {
            this.parseXml(inputStream);
        }
    }

    protected class ParserHandler
    extends DefaultHandler {
        private Locator _locator;
        private Stack _elementStack = new Stack();
        private boolean _readChars;
        private String _key;
        private String _poolName;
        private HashMap _elemAttributeMap;

        protected ParserHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this._readChars) {
                HashMap hashMap = (HashMap)this._elemAttributeMap.get(this.computeCurrentPath());
                StringBuffer stringBuffer = (StringBuffer)hashMap.get(XmlConfiguration.TEXT_CONTENT);
                stringBuffer.append(new String(cArray, n, n2).trim());
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(XmlConfiguration.POOL_ELEMENT)) {
                this._poolName = this.getPoolName(attributes.getValue(XmlConfiguration.POOL_ID));
                if (XmlConfiguration.this._configMap.containsKey(this._poolName)) {
                    XmlConfiguration.this.setSymbolPool(this._poolName);
                    this._elemAttributeMap = (HashMap)XmlConfiguration.this._attributeMap.get(this._poolName);
                } else {
                    XmlConfiguration.this.createSymbolPool(this._poolName);
                    this._elemAttributeMap = new HashMap();
                    XmlConfiguration.this._attributeMap.put(this._poolName, this._elemAttributeMap);
                }
            } else if (!string3.equals(XmlConfiguration.ROOT_ELEMENT_NAME)) {
                this._readChars = true;
                if (string3.equals(XmlConfiguration.PROPERTY_ELEMENT)) {
                    this._key = attributes.getValue(XmlConfiguration.ATTR_PROPERTY_NAME);
                    if (this._key == null || this._key.length() == 0) {
                        throw new SAXException("No name defined for property in pool " + this._poolName);
                    }
                    this._elementStack.push(".property");
                    HashMap<String, StringBuffer> hashMap = new HashMap<String, StringBuffer>();
                    hashMap.put(XmlConfiguration.TEXT_CONTENT, new StringBuffer());
                    this._elemAttributeMap.put(this.computeCurrentPath(), hashMap);
                } else {
                    this._elementStack.push(string3);
                    String string4 = this.computeCurrentPath();
                    HashMap<String, CharSequence> hashMap = (HashMap<String, CharSequence>)this._elemAttributeMap.get(string4);
                    if (hashMap == null) {
                        hashMap = new HashMap<String, CharSequence>();
                        hashMap.put(XmlConfiguration.TEXT_CONTENT, new StringBuffer());
                        this._elemAttributeMap.put(string4, hashMap);
                    }
                    if (attributes.getLength() > 0) {
                        int n = 0;
                        while (n < attributes.getLength()) {
                            hashMap.put(attributes.getQName(n), attributes.getValue(n));
                            ++n;
                        }
                    }
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(XmlConfiguration.POOL_ELEMENT)) {
                XmlConfiguration.this._attributeMap.put(this._poolName, this._elemAttributeMap);
                this._readChars = false;
            } else if (!string3.equals(XmlConfiguration.ROOT_ELEMENT_NAME)) {
                HashMap hashMap = (HashMap)this._elemAttributeMap.get(this.computeCurrentPath());
                String string4 = ((StringBuffer)hashMap.get(XmlConfiguration.TEXT_CONTENT)).toString();
                String string5 = (String)hashMap.get(XmlConfiguration.ATTR_CONTENT_TYPE);
                this.mapAndSetParameter(string4, string5);
                ((StringBuffer)hashMap.get(XmlConfiguration.TEXT_CONTENT)).setLength(0);
                this._elementStack.pop();
                this._readChars = !this._elementStack.empty();
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            XmlConfiguration.this.logger.log(Level.SEVERE, "SAX parse exception -- line: " + this._locator.getLineNumber() + ", column: " + this._locator.getColumnNumber(), sAXParseException);
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            XmlConfiguration.this.logger.log(Level.WARNING, "SAX parse exception -- line: " + this._locator.getLineNumber() + ", column: " + this._locator.getColumnNumber(), sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            XmlConfiguration.this.logger.log(Level.SEVERE, "SAX parse exception -- line: " + this._locator.getLineNumber() + ", column: " + this._locator.getColumnNumber(), sAXParseException);
            throw sAXParseException;
        }

        private String computeCurrentPath() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this._elementStack.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append('.');
            }
            return stringBuffer.toString();
        }

        private String getPoolName(String string) throws SAXException {
            if (string == null || string.length() == 0) {
                throw new SAXException("No id defined for pool");
            }
            String string2 = XmlConfiguration.this._currentXmlFilePrefix == null || XmlConfiguration.this._currentXmlFilePrefix.equals(XmlConfiguration.ACTF_XML_PREFIX) ? string : String.valueOf(XmlConfiguration.this._currentXmlFilePrefix) + '_' + string;
            return string2;
        }

        private void mapAndSetParameter(String string, String string2) {
            String string3 = this.computeCurrentPath();
            if (string == null) {
                string = "";
            }
            if (string3.equals(".property")) {
                string3 = this._key;
            }
            if (string2 == null || string2.equals(String.class.getName())) {
                XmlConfiguration.this.setParameter(string3, string);
            } else if (string2.equals(Class.class.getName())) {
                Class clazz = ClassLoaderCache.getDefault().classForName(string);
                if (clazz != null) {
                    XmlConfiguration.this.setParameter(string3, clazz.getName());
                } else {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Could not find class for value " + string);
                }
            } else if (string2.equals(Integer.TYPE.getName()) || string2.equals(Integer.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(string3, Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + string3);
                }
            } else if (string2.equals(Double.TYPE.getName()) || string2.equals(Double.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(string3, Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + string3);
                }
            } else if (string2.equals(Long.TYPE.getName()) || string2.equals(Long.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(string3, Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + string3);
                }
            } else if (string2.equals(Float.TYPE.getName()) || string2.equals(Float.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(string3, Float.parseFloat(string));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + string3);
                }
            } else if (string2.equals(Boolean.TYPE.getName()) || string2.equals(Boolean.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(string3, Boolean.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + string3);
                }
            } else {
                XmlConfiguration.this.setParameter(string3, string.toString());
            }
        }
    }
}

