/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCaptionElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class SHTableElement
extends SHElement
implements HTMLTableElement {
    private static final long serialVersionUID = -4310847532198779587L;

    protected SHTableElement(String name, SHDocument doc) {
        super(name, doc);
    }

    public HTMLTableCaptionElement getCaption() {
        Node ret = this.getFirstChild();
        while (ret != null) {
            if (ret instanceof HTMLTableCaptionElement) {
                return (HTMLTableCaptionElement)ret;
            }
            ret = ret.getNextSibling();
        }
        return null;
    }

    public void setCaption(HTMLTableCaptionElement caption) {
        this.insertBefore(caption, this.getFirstChild());
    }

    public HTMLTableSectionElement getTHead() {
        Node ret = this.getFirstChild();
        while (ret != null) {
            if (ret instanceof HTMLTableSectionElement && ret.getNodeName().equalsIgnoreCase("THEAD")) {
                return (HTMLTableSectionElement)ret;
            }
            ret = ret.getNextSibling();
        }
        return null;
    }

    public void setTHead(HTMLTableSectionElement tHead) {
        Node after = this.getFirstChild();
        while (after != null) {
            if (after instanceof HTMLTableSectionElement) {
                this.insertBefore(tHead, after);
            }
            after = after.getNextSibling();
        }
        this.insertBefore(tHead, this.getLastChild());
    }

    public HTMLTableSectionElement getTFoot() {
        Node ret = this.getFirstChild();
        while (ret != null) {
            if (ret instanceof HTMLTableSectionElement && ret.getNodeName().equalsIgnoreCase("TFOOT")) {
                return (HTMLTableSectionElement)ret;
            }
            ret = ret.getNextSibling();
        }
        return null;
    }

    public void setTFoot(HTMLTableSectionElement tFoot) {
        Node after = this.getFirstChild();
        while (after != null) {
            if (after instanceof HTMLTableSectionElement && after.getNodeName().equalsIgnoreCase("TBODY")) {
                this.insertBefore(tFoot, after);
            }
            after = after.getNextSibling();
        }
        this.insertBefore(tFoot, this.getLastChild());
    }

    public HTMLCollection getRows() {
        int len = 0;
        Node[] rows = new HTMLTableRowElement[16];
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableSectionElement) {
                Node row = child.getFirstChild();
                while (row != null) {
                    if (row instanceof HTMLTableRowElement) {
                        if (rows.length == len) {
                            HTMLTableRowElement[] buf = new HTMLTableRowElement[len * 2];
                            System.arraycopy(rows, 0, buf, 0, len);
                            rows = buf;
                        }
                        rows[len++] = (HTMLTableRowElement)row;
                    }
                    row = row.getNextSibling();
                }
            } else if (child instanceof HTMLTableRowElement) {
                if (rows.length == len) {
                    HTMLTableRowElement[] buf = new HTMLTableRowElement[len * 2];
                    System.arraycopy(rows, 0, buf, 0, len);
                    rows = buf;
                }
                rows[len++] = (HTMLTableRowElement)child;
            }
            child = child.getNextSibling();
        }
        return ((SHDocument)this.getOwnerDocument()).createCollection(rows, len);
    }

    public HTMLCollection getTBodies() {
        int len = 0;
        Node[] tbodies = new HTMLTableSectionElement[16];
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableSectionElement && child.getNodeName().equalsIgnoreCase("TBODY")) {
                if (tbodies.length == len) {
                    HTMLTableSectionElement[] buf = new HTMLTableSectionElement[len * 2];
                    System.arraycopy(tbodies, 0, buf, 0, len);
                    tbodies = buf;
                }
                tbodies[len++] = (HTMLTableSectionElement)child;
            }
            child = child.getNextSibling();
        }
        return ((SHDocument)this.getOwnerDocument()).createCollection(tbodies, len);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public String getBorder() {
        return this.getAttribute("border");
    }

    public void setBorder(String border) {
        this.setAttribute("border", border);
    }

    public String getCellPadding() {
        return this.getAttribute("cellpadding");
    }

    public void setCellPadding(String cellPadding) {
        this.setAttribute("cellpadding", cellPadding);
    }

    public String getCellSpacing() {
        return this.getAttribute("cellspacing");
    }

    public void setCellSpacing(String cellSpacing) {
        this.setAttribute("cellspacing", cellSpacing);
    }

    public String getFrame() {
        return this.getAttribute("frame");
    }

    public void setFrame(String frame) {
        this.setAttribute("frame", frame);
    }

    public String getRules() {
        return this.getAttribute("rules");
    }

    public void setRules(String rules) {
        this.setAttribute("rules", rules);
    }

    public String getSummary() {
        return this.getAttribute("summary");
    }

    public void setSummary(String summary) {
        this.setAttribute("summary", summary);
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setWidth(String width) {
        this.setAttribute("width", width);
    }

    public HTMLElement createTHead() {
        return (HTMLElement)this.getOwnerDocument().createElement("THEAD");
    }

    public void deleteTHead() {
        Node tHead = this.getFirstChild();
        while (tHead != null) {
            if (tHead instanceof HTMLTableSectionElement && tHead.getNodeName().equalsIgnoreCase("THEAD")) {
                this.removeChild(tHead);
                return;
            }
            tHead = tHead.getNextSibling();
        }
    }

    public HTMLElement createTFoot() {
        return (HTMLElement)this.getOwnerDocument().createElement("TFOOT");
    }

    public void deleteTFoot() {
        Node tFoot = this.getFirstChild();
        while (tFoot != null) {
            if (tFoot instanceof HTMLTableSectionElement && tFoot.getNodeName().equalsIgnoreCase("TFOOT")) {
                this.removeChild(tFoot);
                return;
            }
            tFoot = tFoot.getNextSibling();
        }
    }

    public HTMLElement createCaption() {
        return (HTMLElement)this.getOwnerDocument().createElement("CAPTION");
    }

    public void deleteCaption() {
        Node caption = this.getFirstChild();
        while (caption != null) {
            if (caption instanceof HTMLTableSectionElement && caption.getNodeName().equalsIgnoreCase("CAPTION")) {
                this.removeChild(caption);
                return;
            }
            caption = caption.getNextSibling();
        }
    }

    public HTMLElement insertRow(int index) {
        if (index < 0) {
            return null;
        }
        HTMLCollection rows = this.getRows();
        if (rows.getLength() <= index) {
            return null;
        }
        Node after = rows.item(index);
        Node parent = after.getParentNode();
        HTMLElement ret = (HTMLElement)this.getOwnerDocument().createElement("TR");
        parent.insertBefore(ret, after);
        return ret;
    }

    public void deleteRow(int index) {
        if (index < 0) {
            return;
        }
        HTMLCollection rows = this.getRows();
        if (rows.getLength() <= index) {
            return;
        }
        Node row = rows.item(index);
        row.getParentNode().removeChild(row);
    }
}

