/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.actf.model.internal.flash.proxy.Messages;
import org.eclipse.actf.model.internal.flash.proxy.ProxyPlugin;
import org.eclipse.actf.model.internal.flash.proxy.logs.ProxyLogHandler;
import org.eclipse.actf.model.internal.flash.proxy.logs.ProxyLogRecord;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProxyLogView
extends ViewPart {
    public static final String ID = ProxyLogView.class.getName();
    private static final String[] HEADINGS = new String[]{Messages.proxy_message, "ID", Messages.proxy_source, Messages.proxy_time};
    private static final int[] WEIGHTS = new int[]{30, 3, 10, 5};
    private static final int[] ALIGNMENTS = new int[]{16384, 16384, 16384, 16384};
    private static final int ROW_MESSAGE = 0;
    private static final int ROW_ID = 1;
    private static final int ROW_SOURCE = 2;
    private static final int ROW_TIME = 3;
    private TableViewer viewer;
    private ProxyLogViewComparator sorter = new ProxyLogViewComparator();
    private Action clearAction;
    private Action showFineAction;
    private Action copyAction;
    private ViewLabelProvider labelProvider;
    private static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();

    public void refresh() {
        this.viewer.refresh();
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 68356);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < HEADINGS.length) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(WEIGHTS[i]));
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(HEADINGS[i]);
            tc.setAlignment(ALIGNMENTS[i]);
            tc.setResizable(true);
            final int newSortingColumn = i + 1;
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ProxyLogView)ProxyLogView.this).sorter.sortingColumn = newSortingColumn == ((ProxyLogView)ProxyLogView.this).sorter.sortingColumn ? -newSortingColumn : newSortingColumn;
                    ProxyLogView.this.refresh();
                }
            });
            ++i;
        }
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.labelProvider = new ViewLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setComparator((ViewerComparator)this.sorter);
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProxyLogView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showFineAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.clearAction);
        manager.add((IAction)this.copyAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.clearAction);
    }

    private void makeActions() {
        this.clearAction = new Action(Messages.proxy_clear){

            public void run() {
                ProxyLogHandler.clear();
                ProxyLogView.this.viewer.refresh();
            }
        };
        this.clearAction.setToolTipText(Messages.proxy_clear_tip);
        this.clearAction.setImageDescriptor(ProxyPlugin.IMAGE_CLEAR);
        this.showFineAction = new Action(Messages.proxy_show_fine, 2){

            public void run() {
                ProxyLogHandler.setLogLevel(ProxyLogView.this.showFineAction.isChecked() ? Level.FINE : Level.INFO);
            }
        };
        this.copyAction = new Action(Messages.proxy_copy){

            public void run() {
                Object element;
                StringBuffer sb = new StringBuffer();
                int index = 0;
                while ((element = ProxyLogView.this.viewer.getElementAt(index)) != null) {
                    int col = 0;
                    while (col < HEADINGS.length) {
                        sb.append(ProxyLogView.this.labelProvider.getColumnText(element, col));
                        sb.append(col == HEADINGS.length - 1 ? "\r\n" : "\t");
                        ++col;
                    }
                    ++index;
                }
                if (sb.length() > 0) {
                    new Clipboard(Display.getCurrent()).setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        };
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private class ProxyLogViewComparator
    extends ViewerComparator {
        public int sortingColumn = 0;

        private ProxyLogViewComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IBaseLabelProvider labelProvider;
            if (this.sortingColumn != 0 && viewer instanceof TableViewer && (labelProvider = ((TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                int columnIndex = Math.abs(this.sortingColumn) - 1;
                String s1 = ((ITableLabelProvider)labelProvider).getColumnText(e1, columnIndex);
                String s2 = ((ITableLabelProvider)labelProvider).getColumnText(e2, columnIndex);
                int result = 0;
                switch (columnIndex) {
                    case 3: {
                        result = (int)(((ProxyLogRecord)e1).getMillis() - ((ProxyLogRecord)e2).getMillis());
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        result = super.compare(viewer, (Object)s1, (Object)s2);
                    }
                }
                return this.sortingColumn > 0 ? result : -result;
            }
            return 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ProxyLogHandler.getLogs().toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ProxyLogRecord) {
                switch (index) {
                    case 3: {
                        long time = ((ProxyLogRecord)obj).getMillis();
                        return MessageFormat.format((String)"{0,time}", (Object[])new Object[]{new Date(time)});
                    }
                    case 0: {
                        return ((ProxyLogRecord)obj).getMessage();
                    }
                    case 1: {
                        return ((ProxyLogRecord)obj).getID();
                    }
                    case 2: {
                        String logger = ((ProxyLogRecord)obj).getLoggerName();
                        int sep = logger.lastIndexOf(46);
                        if (-1 != sep) {
                            return logger.substring(sep + 1);
                        }
                        return logger;
                    }
                }
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0 && obj instanceof ProxyLogRecord) {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                int level = ((ProxyLogRecord)obj).getLevel().intValue();
                if (level > Level.WARNING.intValue()) {
                    return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
                if (level > Level.INFO.intValue()) {
                    return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                if (level > Level.FINE.intValue()) {
                    return sharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return null;
        }
    }
}

