/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind;

import org.eclipse.actf.visualization.internal.engines.blind.BlindVizEnginePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class ParamBlind {
    public static final int EN = 0;
    public static final int JP = 1;
    public static String BLIND_LAYOUT_MODE = "layout";
    public static String BLIND_BROWSER_MODE = "browser";
    private static ParamBlind INSTANCE;
    public boolean oReplaceImage = true;
    public boolean oVisualizArrival = true;
    public int iLanguage;
    public String visualizeMode;
    public boolean bVisualizeTime = true;
    public boolean bColorizeTags = true;
    public boolean bVisualizeTable = true;
    public int iMaxTime;
    public RGB maxTimeColor;
    public RGB tableHeaderColor;
    public RGB headingTagsColor;
    public RGB inputTagsColor;
    public RGB labelTagsColor;
    public RGB tableBorderColor;

    public static ParamBlind getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ParamBlind();
        }
        return INSTANCE;
    }

    public static void refresh() {
        ParamBlind pb = ParamBlind.getInstance();
        ParamBlind.setValues(pb);
    }

    private static void setValues(ParamBlind pb) {
        IPreferenceStore store = BlindVizEnginePlugin.getDefault().getPreferenceStore();
        pb.iLanguage = store.getDefaultString("actf.visualization.blind.lang").equals("ja") ? 1 : 0;
        pb.visualizeMode = store.getString("actf.visualization.blind.mode");
        pb.iMaxTime = store.getInt("ADesigner.blind.maxTimeSecond");
        pb.maxTimeColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"ADesigner.blind.maxTimeColor");
        pb.tableHeaderColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"ADesigner.blind.tableheaderColor");
        pb.headingTagsColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"ADesigner.blind.headingTagsColor");
        pb.inputTagsColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"ADesigner.blind.inputTagsColor");
        pb.labelTagsColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"ADesigner.blind.labelTagsColor");
        pb.tableBorderColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"ADesigner.blind.tableBorderColor");
    }

    private ParamBlind() {
        ParamBlind.setValues(this);
    }
}

