/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.msp.preferences;

import org.eclipse.actf.ai.tts.TTSRegistry;
import org.eclipse.actf.ai.tts.msp.Messages;
import org.eclipse.actf.ai.tts.msp.MspPlugin;
import org.eclipse.actf.ai.tts.msp.preferences.MspAudioOutputFieldEditor;
import org.eclipse.actf.ai.tts.msp.preferences.MspTestManager;
import org.eclipse.actf.ai.tts.msp.preferences.MspVoiceFieldEditor;
import org.eclipse.actf.ai.voice.preferences.util.GroupFieldEditorVoicePreferencePage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MspPreferencePage
extends GroupFieldEditorVoicePreferencePage
implements IWorkbenchPreferencePage {
    private String orgVoice;
    private String orgAudio;

    public MspPreferencePage() {
        this.setDescription(Messages.tts_msp_description);
        this.setPreferenceStore(MspPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        if (!TTSRegistry.isAvailable((String)"org.eclipse.actf.ai.tts.msp.engine.MspVoice")) {
            this.setMessage(Messages.tts_msp_notAvailable);
            return;
        }
        this.orgVoice = this.getPreferenceStore().getString("org.eclipse.actf.ai.tts.msp.engine.MspVoice");
        this.orgAudio = this.getPreferenceStore().getString("org.eclipse.actf.ai.tts.MspVoice.audioOutput");
        MspVoiceFieldEditor voiceEditor = new MspVoiceFieldEditor(Messages.tts_msp_voicename, this.getFieldEditorParent());
        this.addField((FieldEditor)voiceEditor);
        this.addField((FieldEditor)new MspAudioOutputFieldEditor(Messages.tts_msp_audiooutput, this.getFieldEditorParent()));
        Composite comp = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(128);
        gd.horizontalSpan = voiceEditor.getNumberOfControls();
        comp.setLayoutData((Object)gd);
        Button testButton = new Button(comp, 0);
        testButton.setText(Messages.tts_msp_test);
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MspTestManager.getInstance().speakTest();
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        this.getPreferenceStore().setValue("org.eclipse.actf.ai.tts.msp.engine.MspVoice", this.orgVoice);
        this.getPreferenceStore().setValue("org.eclipse.actf.ai.tts.MspVoice.audioOutput", this.orgAudio);
        return super.performCancel();
    }

    protected void performApply() {
        super.performApply();
        this.orgVoice = this.getPreferenceStore().getString("org.eclipse.actf.ai.tts.msp.engine.MspVoice");
        this.orgAudio = this.getPreferenceStore().getString("org.eclipse.actf.ai.tts.MspVoice.audioOutput");
    }
}

