/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.table.impl;

import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.content.IStyleListener;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TableColumnElementImpl
extends ODFStylableElementImpl
implements TableColumnElement {
    private static final long serialVersionUID = -6481432496309846401L;

    protected TableColumnElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    public String getAttrTableStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        }
        return null;
    }

    public int getAttrTableNumberColumnsRepeated() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated")) {
            return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated"));
        }
        return -1;
    }

    public String getAttrTableDefaultCellStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "default-cell-style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "default-cell-style-name");
        }
        return null;
    }

    public int getTableIndex() {
        TableElement table = this.getTableElement();
        if (table == null) {
            return -1;
        }
        return table.getTableIndex();
    }

    public TableElement getTableElement() {
        TableElement tableElement = null;
        Node parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof TableElement) {
                tableElement = (TableElement)parent;
                break;
            }
            parent = parent.getParentNode();
        }
        return tableElement;
    }

    public int getTableColumnIndex() {
        int columnStartIndex = 0;
        NodeList list = this.getTableElement().getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-column");
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).equals(this)) {
                return columnStartIndex;
            }
            columnStartIndex = ((TableColumnElement)list.item(i)).hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated") ? (columnStartIndex += ((TableColumnElement)list.item(i)).getAttrTableNumberColumnsRepeated()) : ++columnStartIndex;
            ++i;
        }
        return -1;
    }

    public void setStyle(StyleElement style) {
    }

    public StyleElement getStyle() {
        return null;
    }

    public void addStyleListener(IStyleListener listener, String topic) {
    }

    public void removeStyleListener(IStyleListener listener, String topic) {
    }
}

