/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl;

import java.util.ArrayList;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IElementViewerInfoProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ElementInfoProviderExtension {
    private static final String PROVIDER = "provider";
    private static final String ATTR_CLASS = "class";
    private static ElementInfoProviderExtension[] extensions;
    private static IElementViewerInfoProvider[] providers;
    private IElementViewerInfoProvider provider = null;

    static {
        providers = null;
    }

    public static IElementViewerInfoProvider[] getProviders() {
        if (providers != null) {
            return providers;
        }
        ElementInfoProviderExtension[] tmpExtensions = ElementInfoProviderExtension.getExtensions();
        ArrayList<IElementViewerInfoProvider> tmpList = new ArrayList<IElementViewerInfoProvider>();
        if (tmpExtensions != null) {
            int i = 0;
            while (i < tmpExtensions.length) {
                IElementViewerInfoProvider tmpProvider = tmpExtensions[i].getElementViewerInfoProvider();
                if (tmpProvider != null) {
                    tmpList.add(tmpProvider);
                }
                ++i;
            }
        }
        providers = new IElementViewerInfoProvider[tmpList.size()];
        tmpList.toArray(providers);
        return providers;
    }

    private static ElementInfoProviderExtension[] getExtensions() {
        if (extensions != null) {
            return extensions;
        }
        IExtension[] tmpExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.visualization.engines.blind.html", "elementInfoProvider").getExtensions();
        DebugPrintUtil.devOrDebugPrintln((Object)("ElementInfo extensions:" + tmpExtensions.length));
        ArrayList<ElementInfoProviderExtension> l = new ArrayList<ElementInfoProviderExtension>();
        int i = 0;
        while (i < tmpExtensions.length) {
            IConfigurationElement[] configElements = tmpExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                ElementInfoProviderExtension ex = ElementInfoProviderExtension.parseExtension(configElements[j]);
                if (ex != null) {
                    l.add(ex);
                }
                ++j;
            }
            ++i;
        }
        extensions = l.toArray(new ElementInfoProviderExtension[l.size()]);
        return extensions;
    }

    private static ElementInfoProviderExtension parseExtension(IConfigurationElement configElement) {
        if (!configElement.getName().equals(PROVIDER)) {
            return null;
        }
        try {
            return new ElementInfoProviderExtension(configElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ElementInfoProviderExtension(IConfigurationElement configElement) {
        try {
            this.provider = (IElementViewerInfoProvider)configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {}
    }

    private IElementViewerInfoProvider getElementViewerInfoProvider() {
        return this.provider;
    }
}

