/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import org.eclipse.actf.visualization.internal.engines.lowvision.Messages;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorLAB;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;

public class EnoughContrastRecommendation
extends LowVisionRecommendation {
    public static final float RECOMMENDED_DELTA_L_FOR_TEXT = 45.0f;
    public static final float MID_L = 50.0f;
    private int originalForegroundColor = -1;
    private int originalBackgroundColor = -1;
    private int recommendedForegroundColor = -1;
    private int recommendedBackgroundColor = -1;

    public EnoughContrastRecommendation(LowVisionProblem _prob, int _fg, int _bg) throws LowVisionProblemException {
        super((short)1, _prob, Messages.EnoughContrastRecommendation_Provide_enough_contrast_between_foreground_and_background_colors__1);
        this.originalForegroundColor = _fg;
        this.originalBackgroundColor = _bg;
        this.calcRecommendedColors();
    }

    private void calcRecommendedColors() throws LowVisionProblemException {
        if (this.originalForegroundColor == -1 || this.originalBackgroundColor == -1) {
            return;
        }
        try {
            ColorLAB foreLAB = new ColorIRGB(this.originalForegroundColor).toXYZ().toLAB();
            ColorLAB backLAB = new ColorIRGB(this.originalBackgroundColor).toXYZ().toLAB();
            if (ColorLAB.deltaL(foreLAB, backLAB) >= 45.0f) {
                this.recommendedForegroundColor = this.originalForegroundColor;
                this.recommendedBackgroundColor = this.originalBackgroundColor;
                return;
            }
            float foreL = foreLAB.getL();
            float foreA = foreLAB.getA();
            float foreB = foreLAB.getB();
            float backL = backLAB.getL();
            float backA = backLAB.getA();
            float backB = backLAB.getB();
            if (foreL > backL) {
                if (backL >= 50.0f) {
                    backL = foreL - 45.0f;
                } else if (foreL <= 50.0f) {
                    foreL = backL + 45.0f;
                } else {
                    foreL = (foreL + backL + 45.0f) / 2.0f;
                    backL = foreL - 45.0f;
                }
            } else if (foreL >= 50.0f) {
                foreL = backL - 45.0f;
            } else if (backL <= 50.0f) {
                backL = foreL + 45.0f;
            } else {
                backL = (foreL + backL + 45.0f) / 2.0f;
                foreL = backL - 45.0f;
            }
            this.recommendedForegroundColor = new ColorLAB(foreL, foreA, foreB).toXYZ().toIRGB().toInt();
            this.recommendedBackgroundColor = new ColorLAB(backL, backA, backB).toXYZ().toIRGB().toInt();
        }
        catch (ColorException ce) {
            ce.printStackTrace();
            throw new LowVisionProblemException("Error occurred while calculating recommended colors.");
        }
    }

    public int getOriginalForegroundColor() {
        return this.originalForegroundColor;
    }

    public int getOriginalBackgroundColor() {
        return this.originalBackgroundColor;
    }

    public int getRecommendedForegroundColor() {
        return this.recommendedForegroundColor;
    }

    public int getRecommendedBackgroundColor() {
        return this.recommendedBackgroundColor;
    }
}

