/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYXY;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class CVDOp
implements ILowVisionOperator {
    private static final boolean PRESERVE_SRGB_Y = false;
    private static final float R_YY = 0.21347046f;
    private static final float R_X = 0.6524872f;
    private static final float R_Y = 0.32519758f;
    private static final float G_YY = 0.71173096f;
    private static final float G_X = 0.3305722f;
    private static final float G_Y = 0.5944182f;
    private static final float B_YY = 0.07168579f;
    private static final float B_X = 0.1482494f;
    private static final float B_Y = 0.07736899f;
    private static final float W_YY = 0.9963379f;
    private static final float W_X = 0.34579438f;
    private static final float W_Y = 0.35854465f;
    private static final float C1_X = 0.747f;
    private static final float C1_Y = 0.253f;
    private static final float C2_X = 1.08f;
    private static final float C2_Y = -0.08f;
    private static final float C3_X = 0.171f;
    private static final float C3_Y = 0.0f;
    private static float BW_A = 1.4233501f;
    private static float BW_B = 0.07736899f - BW_A * 0.1482494f;
    private static float BR_A = -0.5f;
    private static float BR_B = 0.525f;
    private int type = 0;

    public CVDOp(int _type) {
        this.type = _type;
    }

    public BufferedImage filter(BufferedImage _src, BufferedImage _dest) throws LowVisionException {
        WritableRaster destRaster;
        DataBufferInt destBufInt;
        int[] destArray;
        int destSize;
        if (this.type != 1 && this.type != 2 && this.type != 3) {
            throw new LowVisionException("Invalid type: " + this.type);
        }
        WritableRaster srcRaster = _src.copyData(null);
        DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
        int[] srcArray = srcBufInt.getData();
        int srcSize = srcArray.length;
        BufferedImage destImage = _dest;
        if (_dest == null) {
            destImage = new BufferedImage(_src.getWidth(), _src.getHeight(), 1);
        }
        if (srcSize != (destSize = (destArray = (destBufInt = (DataBufferInt)(destRaster = destImage.copyData(null)).getDataBuffer()).getData()).length)) {
            throw new LowVisionException("Sizes of src and dest images differ.");
        }
        HashMap<Integer, Integer> pixelMap = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < srcSize) {
            Integer srcPixel = new Integer(srcArray[i]);
            Integer destPixel = null;
            destPixel = (Integer)pixelMap.get(srcPixel);
            if (destPixel == null) {
                destPixel = new Integer(CVDOp.convertColor(srcArray[i], this.type));
                pixelMap.put(srcPixel, destPixel);
            }
            destArray[i] = destPixel;
            ++i;
        }
        destImage.setData(destRaster);
        return destImage;
    }

    public IInt2D filter(Int2D _src, Int2D _dest) throws LowVisionException {
        if (this.type != 1 && this.type != 2 && this.type != 3) {
            throw new LowVisionException("Invalid type: " + this.type);
        }
        Int2D destImage = _dest;
        if (_dest == null) {
            destImage = new Int2D(_src.getWidth(), _src.getHeight());
        }
        HashMap<Integer, Integer> pixelMap = new HashMap<Integer, Integer>();
        int j = 0;
        while (j < _src.getHeight()) {
            int i = 0;
            while (i < _src.getWidth()) {
                int srcColor = _src.getData()[j][i];
                Integer srcPixel = new Integer(srcColor);
                Integer destPixel = (Integer)pixelMap.get(srcPixel);
                if (destPixel == null) {
                    int destColor;
                    destImage.getData()[j][i] = destColor = CVDOp.convertColor(srcColor, this.type);
                    pixelMap.put(srcPixel, new Integer(destColor));
                } else {
                    destImage.getData()[j][i] = destPixel;
                }
                ++i;
            }
            ++j;
        }
        return destImage;
    }

    public static int convertColor(int _src, int _type) throws LowVisionException {
        try {
            ColorIRGB irgb = new ColorIRGB(_src);
            ColorYXY yxy = irgb.toYXY();
            ColorYXY newYXY = CVDOp.moveXY(yxy, _type);
            ColorIRGB newIRGB = newYXY.toIRGB();
            return newIRGB.toInt();
        }
        catch (ColorException ce) {
            ce.printStackTrace();
            throw new LowVisionException("ColorException occurred while converting color.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ColorYXY moveXY(ColorYXY _src, int _type) throws LowVisionException, ColorException {
        float srcYY = _src.getYY();
        float srcX = _src.getX();
        float srcY = _src.getY();
        float confuseX = 0.0f;
        float confuseY = 0.0f;
        float locusA = 0.0f;
        float locusB = 0.0f;
        if (_type == 1) {
            confuseX = 0.747f;
            confuseY = 0.253f;
            locusA = BW_A;
            locusB = BW_B;
        } else if (_type == 2) {
            confuseX = 1.08f;
            confuseY = -0.08f;
            locusA = BW_A;
            locusB = BW_B;
        } else {
            if (_type != 3) throw new LowVisionException("Invalid type : " + _type);
            confuseX = 0.171f;
            confuseY = 0.0f;
            locusA = BR_A;
            locusB = BR_B;
        }
        float destYY = srcYY;
        float destX = 0.0f;
        float destY = 0.0f;
        if (confuseX != srcX) {
            float confuseA = (confuseY - srcY) / (confuseX - srcX);
            float confuseB = confuseY - confuseA * confuseX;
            if (confuseA == locusA) throw new LowVisionException("(x,y) is out of sRGB's range. (x,y) = " + srcX + ", " + srcY);
            destX = (confuseB - locusB) / (locusA - confuseA);
            destY = (locusA * confuseB - confuseA * locusB) / (locusA - confuseA);
            return new ColorYXY(destYY, destX, destY);
        } else {
            destX = confuseX;
            destY = confuseX * locusA + locusB;
        }
        return new ColorYXY(destYY, destX, destY);
    }
}

