/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.BMPWriter;

public class Int2D
implements IInt2D {
    private int width;
    private int height;
    private int[][] data;

    public Int2D(int _w, int _h) {
        this.width = _w;
        this.height = _h;
        this.data = new int[this.getHeight()][this.getWidth()];
    }

    public Int2D(int _w, int _h, int[][] _array) throws ImageException {
        this(_w, _h);
        if (_array.length < _h || _array[0].length < _w) {
            throw new ImageException("Out of range");
        }
        int j = 0;
        while (j < this.getHeight()) {
            int i = 0;
            while (i < this.getWidth()) {
                this.getData()[j][i] = _array[j][i];
                ++i;
            }
            ++j;
        }
    }

    public Int2D(Int2D _src) {
        this(_src.getWidth(), _src.getHeight());
        int j = 0;
        while (j < this.getHeight()) {
            int i = 0;
            while (i < this.getWidth()) {
                this.getData()[j][i] = _src.getData()[j][i];
                ++i;
            }
            ++j;
        }
    }

    public Int2D(BufferedImage _bi) {
        this(_bi.getWidth(), _bi.getHeight());
        WritableRaster srcRaster = _bi.copyData(null);
        DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
        int[] srcArray = srcBufInt.getData();
        int k = 0;
        int j = 0;
        while (j < this.getHeight()) {
            int i = 0;
            while (i < this.getWidth()) {
                this.getData()[j][i] = srcArray[k];
                ++k;
                ++i;
            }
            ++j;
        }
    }

    public Int2D deepCopy() {
        Int2D dest = new Int2D(this.width, this.height);
        int[][] destData = dest.getData();
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                destData[j][i] = this.data[j][i];
                ++i;
            }
            ++j;
        }
        return dest;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage toBufferedImage() {
        return ImageUtil.int2DToBufferedImage(this);
    }

    public void writeToBMPFile(String _fileName) throws LowVisionIOException {
        BMPWriter.writeInt2D(this, _fileName);
    }

    public void writeToBMPFile(String _fileName, int _bitCount) throws LowVisionIOException {
        BMPWriter.writeInt2D(this, _fileName, _bitCount);
    }

    public void fill(int _color) {
        int j = 0;
        while (j < this.getHeight()) {
            int i = 0;
            while (i < this.getWidth()) {
                this.getData()[j][i] = _color;
                ++i;
            }
            ++j;
        }
    }

    public Int2D cutMargin(int _m) throws ImageException {
        if (this.getWidth() <= 2 * _m || this.getHeight() <= 2 * _m) {
            throw new ImageException("The margin is too wide.");
        }
        int newW = this.getWidth() - 2 * _m;
        int newH = this.getHeight() - 2 * _m;
        Int2D i2d = new Int2D(newW, newH);
        int j = 0;
        while (j < newH) {
            int i = 0;
            while (i < newW) {
                i2d.getData()[j][i] = this.getData()[j + _m][i + _m];
                ++i;
            }
            ++j;
        }
        return i2d;
    }

    public void drawContour(ConnectedComponent _cc, int _color, boolean _overWrite) {
        Int2D dest = this;
        if (!_overWrite) {
            dest = this.deepCopy();
        }
        int ccLeft = _cc.left;
        int ccTop = _cc.top;
        int ccWidth = _cc.shape.width;
        int ccHeight = _cc.shape.height;
        int j = 0;
        while (j < ccHeight) {
            if (_cc.shape.data[j][0] != 0) {
                dest.getData()[j + ccTop][ccLeft] = _color;
            }
            if (_cc.shape.data[j][ccWidth - 1] != 0) {
                dest.getData()[j + ccTop][ccWidth - 1 + ccLeft] = _color;
            }
            ++j;
        }
        int i = 0;
        while (i < ccWidth) {
            if (_cc.shape.data[0][i] != 0) {
                dest.getData()[ccTop][i + ccLeft] = _color;
            }
            if (_cc.shape.data[ccHeight - 1][0] != 0) {
                dest.getData()[ccHeight - 1 + ccTop][ccLeft] = _color;
            }
            ++i;
        }
        j = 1;
        while (j < ccHeight - 1) {
            int i2 = 1;
            while (i2 < ccWidth - 1) {
                if (_cc.shape.data[j][i2] != 0 && (_cc.shape.data[j][i2 - 1] == 0 || _cc.shape.data[j][i2 + 1] == 0 || _cc.shape.data[j - 1][i2] == 0 || _cc.shape.data[j + 1][i2] == 0)) {
                    dest.getData()[j + ccTop][i2 + ccLeft] = _color;
                }
                ++i2;
            }
            ++j;
        }
    }

    public int[][] getData() {
        return this.data;
    }
}

