/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;

public class Coord {
    int x;
    int y;

    public Coord(int _x, int _y) {
        this.x = _x;
        this.y = _y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void set(int _x, int _y) {
        this.x = _x;
        this.y = _y;
    }

    public void setX(int _x) {
        this.x = _x;
    }

    public void setY(int _y) {
        this.y = _y;
    }

    public void copy(Coord _co) {
        this.x = _co.x;
        this.y = _co.y;
    }

    public boolean isOrigin() {
        return this.x == 0 && this.y == 0;
    }

    public boolean equals(Coord _co) {
        return this.x == _co.x && this.y == _co.y;
    }

    public static Coord add(Coord _a, Coord _b) {
        return new Coord(_a.x + _b.x, _a.y + _b.y);
    }

    public Coord add(Coord _b) {
        return Coord.add(this, _b);
    }

    public static Coord subtract(Coord _a, Coord _b) {
        return new Coord(_a.x - _b.x, _a.y - _b.y);
    }

    public Coord subtract(Coord _b) {
        return Coord.subtract(this, _b);
    }

    public static int distancePow2(Coord _a, Coord _b) {
        int xDif = _a.x - _b.x;
        int yDif = _a.y - _b.y;
        return xDif * xDif + yDif * yDif;
    }

    public static int distancePow2(Coord _a) {
        return _a.x * _a.x + _a.y * _a.y;
    }

    public static double distance(Coord _a, Coord _b) {
        return Math.sqrt(Coord.distancePow2(_a, _b));
    }

    public static double distance(Coord _a) {
        return Math.sqrt(Coord.distancePow2(_a));
    }

    public static boolean isOnLine(Coord _start, Coord _end, Coord _point) {
        Coord vector2;
        Coord vector1 = Coord.subtract(_end, _start);
        return Coord.outerProduct(vector1, vector2 = Coord.subtract(_point, _start)) == 0;
    }

    public static boolean isLeftToVector(Coord _start, Coord _end, Coord _point) {
        Coord vector1 = Coord.subtract(_end, _start);
        Coord vector2 = Coord.subtract(_point, _start);
        return Coord.outerProduct(vector2, vector1) > 0;
    }

    public static boolean isRightToVector(Coord _start, Coord _end, Coord _point) {
        Coord vector2;
        Coord vector1 = Coord.subtract(_end, _start);
        return Coord.outerProduct(vector1, vector2 = Coord.subtract(_point, _start)) > 0;
    }

    public static int innerProduct(Coord _a, Coord _b) {
        return _a.x * _b.x + _a.y * _b.y;
    }

    public static double cosine(Coord _a, Coord _b) throws ImageException {
        if (_a.isOrigin() || _b.isOrigin()) {
            throw new ImageException("Cannot calculate cosine of zero-vectors");
        }
        return (double)Coord.innerProduct(_a, _b) / (Coord.distance(_a) * Coord.distance(_b));
    }

    public static int outerProduct(Coord _a, Coord _b) {
        return _a.x * _b.y - _a.y * _b.x;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw);
    }

    public void dump(PrintWriter _pw) {
        _pw.println("-------------------------------");
        _pw.println("Dumping a point");
        _pw.println("(" + this.x + "," + this.y + ")");
        _pw.println("-------------------------------");
    }

    public static void dump(PrintStream _ps, Coord[] _points) {
        PrintWriter pw = new PrintWriter(_ps, true);
        Coord.dump(pw, _points);
    }

    public static void dump(PrintWriter _pw, Coord[] _points) {
        int numPoints = _points.length;
        _pw.println("-------------------------------");
        _pw.println("Dumping points");
        _pw.println("# of points = " + numPoints);
        int i = 0;
        while (i < numPoints) {
            _pw.println("(" + _points[i].x + "," + _points[i].y + ")");
            _pw.println("-----");
            ++i;
        }
    }
}

