/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;

public class ColorUtil {
    private static final String[] predefinedColors = new String[]{"black", "#000000", "silver", "#c0c0c0", "gray", "#808080", "grey", "#808080", "white", "#ffffff", "maroon", "#800000", "red", "#ff0000", "purple", "#800080", "fuchsia", "#ff00ff", "green", "#008000", "lime", "#00ff00", "olive", "#808000", "yellow", "#ffff00", "navy", "#000080", "blue", "#0000ff", "teal", "#008080", "aqua", "#00ffff"};
    private static final int numPredefinedColors = predefinedColors.length / 2;

    public static boolean isPredefinedColor(String _s) {
        String s = _s.toLowerCase();
        int i = 0;
        while (i < numPredefinedColors) {
            if (predefinedColors[i * 2].equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String predefinedColor2Pound(String _s) {
        String s = _s.toLowerCase();
        int i = 0;
        while (i < numPredefinedColors) {
            if (predefinedColors[i * 2].equals(s)) {
                return predefinedColors[i * 2 + 1];
            }
            ++i;
        }
        return null;
    }

    public static int[] intToRGB(int _i) {
        int[] rgb = new int[]{_i >> 16 & 0xFF, _i >> 8 & 0xFF, _i & 0xFF};
        return rgb;
    }

    public static int RGBToInt(int _r, int _g, int _b) {
        return (_r & 0xFF) << 16 | (_g & 0xFF) << 8 | _b & 0xFF;
    }

    public static void dumpColor(PrintStream _ps, int _i) {
        new ColorIRGB(_i).dump(_ps);
    }

    public static void dumpColor(PrintWriter _pw, int _i) {
        new ColorIRGB(_i).dump(_pw);
    }

    public static int distinguishableColor(int _id) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (_id == 0) {
            return 0xFFFFFF;
        }
        int l = 0;
        while (l < 8) {
            r += (_id >> l * 3 & 1) << 7 - l;
            g += (_id >> l * 3 + 1 & 1) << 7 - l;
            b += (_id >> l * 3 + 2 & 1) << 7 - l;
            ++l;
        }
        return r << 16 | g << 8 | b;
    }
}

