/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorXYZ;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYIQ;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYXY;

public class ColorSRGB {
    private ICC_ColorSpace cs;
    private float[] rgb = new float[3];

    public ColorSRGB(float _r, float _g, float _b) throws ColorException {
        this.cs = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        this.setR(_r);
        this.setG(_g);
        this.setB(_b);
    }

    public ColorSRGB(float _r, float _g, float _b, boolean _check) throws ColorException {
        this.cs = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        this.setR(_r, _check);
        this.setG(_g, _check);
        this.setB(_b, _check);
    }

    public float getR() {
        return this.rgb[0];
    }

    public float getG() {
        return this.rgb[1];
    }

    public float getB() {
        return this.rgb[2];
    }

    public void setR(float _r) throws ColorException {
        this.setR(_r, false);
    }

    public void setR(float _r, boolean _check) throws ColorException {
        if (_r < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.rgb[0] = 0.0f;
        } else if (1.0f < _r) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.rgb[0] = 1.0f;
        } else {
            this.rgb[0] = _r;
        }
    }

    public void setG(float _g) throws ColorException {
        this.setG(_g, false);
    }

    public void setG(float _g, boolean _check) throws ColorException {
        if (_g < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.rgb[1] = 0.0f;
        } else if (1.0f < _g) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.rgb[1] = 1.0f;
        } else {
            this.rgb[1] = _g;
        }
    }

    public void setB(float _b) throws ColorException {
        this.setB(_b, false);
    }

    public void setB(float _b, boolean _check) throws ColorException {
        if (_b < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.rgb[2] = 0.0f;
        } else if (1.0f < _b) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.rgb[2] = 1.0f;
        } else {
            this.rgb[2] = _b;
        }
    }

    public ColorIRGB toIRGB() throws ColorException {
        return this.toIRGB(false);
    }

    public ColorIRGB toIRGB(boolean _check) throws ColorException {
        int ir = Math.round(this.rgb[0] * 255.0f);
        int ig = Math.round(this.rgb[1] * 255.0f);
        int ib = Math.round(this.rgb[2] * 255.0f);
        ColorIRGB i = new ColorIRGB();
        i.setR(ir, _check);
        i.setG(ig, _check);
        i.setB(ib, _check);
        return i;
    }

    public ColorXYZ toXYZ() throws ColorException {
        return this.toXYZ(false);
    }

    public ColorXYZ toXYZ(boolean _check) throws ColorException {
        float[] fxyz = null;
        boolean success = false;
        while (!success) {
            try {
                fxyz = this.cs.toCIEXYZ(this.rgb);
                success = true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        ColorXYZ xyz = new ColorXYZ();
        xyz.setX(fxyz[0], _check);
        xyz.setY(fxyz[1], _check);
        xyz.setZ(fxyz[2], _check);
        return xyz;
    }

    public ColorYXY toYXY() throws ColorException {
        return this.toYXY(false);
    }

    public ColorYXY toYXY(boolean _check) throws ColorException {
        return this.toXYZ(_check).toYXY(_check);
    }

    public ColorYIQ toYIQ() throws ColorException {
        return new ColorYIQ(this);
    }

    public ColorYIQ toYIQ(boolean _check) throws ColorException {
        return new ColorYIQ(this, _check);
    }
}

