/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;

public abstract class HTTPHeader
implements IHTTPHeader {
    private boolean isRemoved = false;

    public static byte toUpcase(byte b) {
        if (b >= 97 && b <= 122) {
            return (byte)(b - 32);
        }
        return b;
    }

    public static boolean compare(byte[] v1, byte[] v2) {
        int len = v1.length;
        if (len != v2.length) {
            return false;
        }
        int i = len - 1;
        while (i >= 0) {
            if (v1[i] != v2[i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean compareIgnoreCase(byte[] v1, byte[] v2) {
        int len = v1.length;
        if (len != v2.length) {
            return false;
        }
        int i = len - 1;
        while (i >= 0) {
            if (HTTPHeader.toUpcase(v1[i]) != HTTPHeader.toUpcase(v2[i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    protected HTTPHeader() {
    }

    public void setRemoved(boolean removed) {
        this.isRemoved = removed;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public abstract boolean isFieldNameEqualsTo(byte[] var1);

    public abstract boolean isFieldValueEqualsTo(byte[] var1);

    public abstract byte[] getName();

    public abstract byte[] getValue();

    public abstract void setValue(byte[] var1);

    protected abstract void write(OutputStream var1) throws IOException;

    protected void writeHeaderSeparator(OutputStream out) throws IOException {
        out.write(58);
        out.write(32);
    }

    public boolean compareValue(byte[] value) {
        return HTTPHeader.compare(this.getValue(), value);
    }

    public boolean compareValueIgnoreCase(byte[] value) {
        return HTTPHeader.compareIgnoreCase(this.getValue(), value);
    }

    public void writeLine(OutputStream out) throws IOException {
        if (!this.isRemoved) {
            this.write(out);
            out.write(13);
            out.write(10);
        }
    }

    public String toString() {
        return "Header:" + new String(this.getName()) + ":" + new String(this.getValue());
    }
}

