/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPHeader;

public class HTTPMessageBuffer
extends ByteArrayOutputStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 1024;

    public HTTPMessageBuffer() {
        super(1024);
    }

    public HTTPMessageBuffer(int n) {
        super(n);
    }

    protected HTTPMessageBuffer(byte[] byArray) {
        this.buf = byArray;
        this.count = byArray.length;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public final int getLength() {
        return this.count;
    }

    public String getAsString(IBufferRange iBufferRange) {
        return new String(this.buf, iBufferRange.getStart(), iBufferRange.getLength());
    }

    public byte[] getAsBytes(IBufferRange iBufferRange) {
        int n = iBufferRange.getLength();
        if (n <= 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, iBufferRange.getStart(), byArray, 0, n);
        return byArray;
    }

    public final void writeTo(OutputStream outputStream, IBufferRange iBufferRange) throws IOException {
        outputStream.write(this.buf, iBufferRange.getStart(), iBufferRange.getLength());
    }

    public boolean equals(IBufferRange iBufferRange, byte[] byArray) {
        int n = byArray.length;
        if (n != iBufferRange.getLength()) {
            return false;
        }
        int n2 = iBufferRange.getStart();
        byte[] byArray2 = this.buf;
        int n3 = n - 1;
        while (n3 >= 0) {
            if (byArray[n3] != byArray2[n2 + n3]) {
                return false;
            }
            --n3;
        }
        return true;
    }

    public boolean equalsIgnoreCase(IBufferRange iBufferRange, byte[] byArray) {
        int n = byArray.length;
        if (n != iBufferRange.getLength()) {
            return false;
        }
        int n2 = iBufferRange.getStart();
        byte[] byArray2 = this.buf;
        int n3 = n - 1;
        while (n3 >= 0) {
            if (HTTPHeader.toUpcase(byArray[n3]) != HTTPHeader.toUpcase(byArray2[n2 + n3])) {
                return false;
            }
            --n3;
        }
        return true;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }
}

