/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.util.html2view;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.util.JapaneseEncodingDetector;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Html2ViewMapMaker {
    Vector<Html2ViewMapData> html2viewV;
    int id;
    int line;
    int column;
    int startLine;
    int startColumn;
    boolean changeBase;
    boolean insertBaseNow;
    String baseUrl;
    boolean inXmlDef;
    boolean inDoctype;
    boolean inSingle;
    boolean inDouble;
    boolean inTag;
    boolean inEndTag;
    boolean inComment;
    boolean inScript;
    boolean inScriptComment;
    boolean inNoscript;
    boolean inTitle;
    boolean inHeader;
    StringBuffer resultSB;
    StringBuffer toFindHtmlSB;
    StringBuffer scriptSB;
    String currentTargetString;

    private Html2ViewMapMaker() {
    }

    public static Vector<Html2ViewMapData> makeMap(String filename, String resultFileName, String targetDir) {
        Html2ViewMapMaker maker = new Html2ViewMapMaker();
        maker.changeBase = false;
        return maker.makeMapLocal(filename, resultFileName, targetDir, true);
    }

    private void init() {
        this.inXmlDef = false;
        this.inDoctype = false;
        this.inSingle = false;
        this.inDouble = false;
        this.inTag = false;
        this.inEndTag = false;
        this.inComment = false;
        this.inScript = false;
        this.inScriptComment = false;
        this.insertBaseNow = false;
        this.id = 0;
        this.line = 0;
        this.column = 0;
        this.startLine = 0;
        this.startColumn = 0;
        this.html2viewV = new Vector();
        this.resultSB = new StringBuffer();
    }

    private Vector<Html2ViewMapData> makeMapLocal(String filename, String resultFileName, String tmpDir, boolean useTmpDir) {
        PrintWriter htmlWriter;
        JapaneseEncodingDetector JED;
        String encoding;
        BufferedReader br;
        String _tmpDir;
        FileInputStream fis;
        block35: {
            fis = null;
            _tmpDir = "";
            if (useTmpDir) {
                _tmpDir = tmpDir;
            }
            this.init();
            br = null;
            encoding = "MS932";
            File target = new File(String.valueOf(_tmpDir) + filename);
            if (target.isFile() && target.canRead()) {
                try {
                    try {
                        fis = new FileInputStream(target);
                        JED = new JapaneseEncodingDetector((InputStream)fis);
                        encoding = JED.detect();
                        break block35;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        Vector<Html2ViewMapData> vector = this.html2viewV;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        return vector;
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            return this.html2viewV;
        }
        try {
            FileOutputStream fos = new FileOutputStream(new File(String.valueOf(_tmpDir) + resultFileName));
            BufferedWriter bos = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, encoding));
            htmlWriter = new PrintWriter(bos);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return new Vector<Html2ViewMapData>();
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return new Vector<Html2ViewMapData>();
        }
        try {
            InputStreamReader isr;
            try {
                String tmpS;
                isr = new InputStreamReader(JED.getInputStream(), encoding);
                br = new BufferedReader(isr);
                while ((tmpS = br.readLine()) != null) {
                    this.doSourceLine(tmpS);
                    ++this.line;
                    this.column = 0;
                }
            }
            catch (Exception exception) {
                try {
                    String tmpS;
                    fis.close();
                    this.init();
                    fis = new FileInputStream(String.valueOf(_tmpDir) + filename);
                    isr = new InputStreamReader(fis);
                    br = new BufferedReader(isr);
                    while ((tmpS = br.readLine()) != null) {
                        this.doSourceLine(tmpS);
                        ++this.line;
                        this.column = 0;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    Vector<Html2ViewMapData> vector = new Vector<Html2ViewMapData>();
                    try {
                        fis.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    return vector;
                }
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        htmlWriter.print(this.resultSB.toString());
        htmlWriter.flush();
        htmlWriter.close();
        return this.html2viewV;
    }

    private void doSourceLine(String target) {
        this.currentTargetString = target;
        boolean flag = true;
        while (flag) {
            flag = this.doFilter(this.currentTargetString);
        }
    }

    private boolean doFilter(String targetS) {
        if (targetS == null) {
            return false;
        }
        if (targetS.equals("")) {
            this.resultSB.append(FileUtils.LINE_SEP);
            return false;
        }
        if (this.inSingle) {
            this.doValueSingle(targetS);
        } else if (this.inDouble) {
            this.doValueDouble(targetS);
        } else if (this.inTag) {
            this.doTag(targetS);
        } else if (this.inEndTag) {
            this.doEndTag(targetS);
        } else if (this.inComment) {
            this.doComment(targetS);
        } else if (this.inDoctype) {
            this.doDoctype(targetS);
        } else if (this.inScript) {
            if (this.inScriptComment) {
                this.doScriptComment(targetS);
            } else {
                this.doScript(targetS);
            }
        } else if (this.inXmlDef) {
            this.doXmlDef(targetS);
        } else {
            this.doNormal(targetS);
        }
        return true;
    }

    private void doValueSingle(String targetS) {
        this.doValue(targetS, "'");
    }

    private void doValueDouble(String targetS) {
        this.doValue(targetS, "\"");
    }

    private void doValue(String targetS, String quatation) {
        int endIndex = targetS.indexOf(quatation);
        int startIndex = targetS.indexOf("<");
        if (startIndex > -1 && (endIndex < 0 || endIndex > startIndex)) {
            int threshold = endIndex;
            if (endIndex < 0) {
                threshold = Integer.MAX_VALUE;
            }
            String tmpS = "";
            try {
                tmpS = targetS.substring(startIndex + 1);
            }
            catch (Exception exception) {}
            int tmpLine = this.line + 1;
            while (startIndex > -1 && startIndex < threshold && !tmpS.matches("\\p{Alpha}.*")) {
                if ((startIndex = targetS.indexOf("<", startIndex + 1)) <= -1) continue;
                tmpS = "";
                try {
                    tmpS = targetS.substring(startIndex + 1);
                }
                catch (Exception exception) {}
            }
            if (startIndex > -1 && startIndex < threshold) {
                System.out.print("HTMLVMM: start tag in attribute value : line: " + tmpLine + " : " + targetS + " : ");
                int tagEndIndex = targetS.indexOf(">");
                if (tagEndIndex > -1 && tagEndIndex < startIndex) {
                    targetS = String.valueOf(targetS.substring(0, tagEndIndex)) + quatation + targetS.substring(tagEndIndex);
                    endIndex = targetS.indexOf(quatation);
                    System.out.println("with end tag");
                } else {
                    targetS = String.valueOf(targetS.substring(0, startIndex)) + quatation + ">" + targetS.substring(startIndex);
                    endIndex = targetS.indexOf(quatation);
                    System.out.println("without end tag");
                }
            }
        }
        if (endIndex > -1) {
            this.inSingle = false;
            this.inDouble = false;
            if (this.changeBase) {
                this.toFindHtmlSB.append(targetS.substring(0, endIndex));
            }
            this.doNext(targetS, endIndex);
        } else {
            if (this.changeBase) {
                this.toFindHtmlSB.append(targetS);
            }
            this.doNext(targetS, endIndex);
        }
    }

    private boolean checkIndex(int endIndex, int quatationIndex) {
        if (quatationIndex > -1) {
            return endIndex <= -1 || endIndex >= quatationIndex;
        }
        return false;
    }

    private boolean isUnexpectedStartTag(int singleIndex, int doubleIndex, int endIndex, int startTagIndex) {
        if (startTagIndex > -1) {
            return !(endIndex >= 0 && endIndex <= startTagIndex || singleIndex >= 0 && singleIndex <= startTagIndex || doubleIndex >= 0 && doubleIndex <= startTagIndex);
        }
        return false;
    }

    private int getAttributeIndex(String targetS, boolean isDouble, int endIndex) {
        String quatation = "'";
        if (isDouble) {
            quatation = "\"";
        }
        int threshold = endIndex;
        if (endIndex < 0) {
            threshold = Integer.MAX_VALUE;
        }
        int index = targetS.indexOf(quatation);
        while (index > -1 && index < threshold) {
            String tmpS = targetS.substring(0, index);
            if (tmpS.matches(".*=\\p{Space}*")) {
                return index;
            }
            index = targetS.indexOf(quatation, index + 1);
        }
        return index;
    }

    private void doTag(String targetS) {
        int startIndex;
        int endIndex = targetS.indexOf(">");
        int singleIndex = this.getAttributeIndex(targetS, false, endIndex);
        int doubleIndex = this.getAttributeIndex(targetS, true, endIndex);
        boolean singleC = this.checkIndex(endIndex, singleIndex);
        boolean doubleC = this.checkIndex(endIndex, doubleIndex);
        if (singleC && doubleC) {
            if (doubleIndex < singleIndex) {
                singleC = false;
            } else {
                doubleC = false;
            }
        }
        if (this.isUnexpectedStartTag(singleIndex, doubleIndex, endIndex, startIndex = targetS.indexOf("<"))) {
            int tmpLine = this.line + 1;
            System.out.println("HTMLVMM: unexpected start tag: line:" + tmpLine + " : " + targetS);
            targetS = String.valueOf(targetS.substring(0, startIndex)) + ">" + targetS.substring(startIndex);
            singleC = false;
            doubleC = false;
            endIndex = targetS.indexOf(">");
        }
        if (singleC) {
            this.inSingle = true;
            if (this.changeBase) {
                this.toFindHtmlSB.append(targetS.substring(0, singleIndex));
            }
            this.doNext(targetS, singleIndex);
        } else if (doubleC) {
            this.inDouble = true;
            if (this.changeBase) {
                this.toFindHtmlSB.append(targetS.substring(0, doubleIndex));
            }
            this.doNext(targetS, doubleIndex);
        } else {
            boolean endWithSlash = false;
            if (endIndex > -1) {
                this.inTag = false;
                int tmpIndex = targetS.indexOf("/>");
                if (tmpIndex > -1 && tmpIndex == endIndex - 1) {
                    endWithSlash = true;
                }
                if (this.changeBase) {
                    String tmpS = String.valueOf(this.toFindHtmlSB.toString()) + targetS.substring(0, endIndex);
                    if ((tmpS = tmpS.toLowerCase()).startsWith("html")) {
                        this.changeBase = false;
                        this.insertBaseNow = true;
                    }
                }
                Html2ViewMapData h2vmd = new Html2ViewMapData(new int[]{this.startLine, this.startColumn}, new int[]{this.line, this.column + endIndex + 1});
                this.html2viewV.add(h2vmd);
                this.doNext(targetS, endIndex, true, endWithSlash);
            } else {
                if (this.changeBase) {
                    this.toFindHtmlSB.append(targetS);
                }
                this.doNext(targetS, endIndex);
            }
        }
    }

    private void doEndTag(String targetS) {
        int endIndex = targetS.indexOf(">");
        if (endIndex > -1) {
            this.inEndTag = false;
        }
        this.doNext(targetS, endIndex);
    }

    private void doComment(String targetS) {
        int endIndex = targetS.indexOf("-->");
        if (endIndex > -1) {
            this.inComment = false;
        }
        this.doNext(targetS, endIndex);
    }

    private void doScript(String targetS) {
        int commentIndex = targetS.toLowerCase().indexOf("<!--");
        int endIndex = targetS.toLowerCase().indexOf("</script>");
        this.inScriptComment = this.checkIndex(endIndex, commentIndex);
        if (this.inScriptComment) {
            this.scriptSB.append(targetS.substring(0, commentIndex + 1));
            this.doNext(targetS, commentIndex);
            return;
        }
        if (endIndex > -1) {
            this.scriptSB.append(targetS.substring(0, endIndex + 8));
            String tmpScript = this.scriptSB.toString();
            String tmpScript2 = tmpScript.toLowerCase();
            if (this.changeBase && tmpScript2.indexOf(".createstylesheet") > -1) {
                this.resultSB.insert(this.resultSB.indexOf("<HEAD><BASE") + 6, String.valueOf(tmpScript) + ">");
                this.resultSB.append("<!-- acc_memo script move to top--");
            } else {
                this.resultSB.append(tmpScript);
            }
            targetS = targetS.substring(endIndex + 8);
            endIndex = 0;
            this.inScript = false;
        } else {
            this.scriptSB.append(String.valueOf(targetS) + FileUtils.LINE_SEP);
        }
        this.doNext(targetS, endIndex);
    }

    private void doScriptComment(String targetS) {
        int endIndex = targetS.indexOf("-->");
        if (endIndex > -1) {
            this.scriptSB.append(targetS.substring(0, endIndex + 1));
            this.inScriptComment = false;
        } else {
            this.scriptSB.append(String.valueOf(targetS) + FileUtils.LINE_SEP);
        }
        this.doNext(targetS, endIndex);
    }

    private void doDoctype(String targetS) {
        int endIndex = targetS.indexOf(">");
        if (endIndex > -1) {
            this.inDoctype = false;
        }
        this.doNext(targetS, endIndex);
    }

    private void doXmlDef(String targetS) {
        int endIndex = targetS.indexOf(">");
        if (endIndex > -1) {
            this.inXmlDef = false;
        }
        this.doNext(targetS, endIndex);
    }

    private void doNormal(String targetS) {
        int startIndex = targetS.indexOf("<");
        if (startIndex > -1) {
            this.startLine = this.line;
            this.startColumn = this.column + startIndex;
            String tmpS = targetS.toLowerCase();
            int endTagIndex = tmpS.indexOf("</");
            int tmpIndex = tmpS.indexOf("<!--");
            int tmpIndex2 = tmpS.indexOf("<!doctype");
            int tmpIndex3 = tmpS.indexOf("<script");
            int tmpIndex4 = tmpS.indexOf("<?xml");
            if (startIndex == endTagIndex) {
                this.inEndTag = true;
            } else if (startIndex == tmpIndex) {
                this.inComment = true;
            } else if (startIndex == tmpIndex2) {
                this.inDoctype = true;
            } else if (startIndex == tmpIndex3) {
                this.inScript = true;
                this.scriptSB = new StringBuffer("<");
                this.resultSB.append(targetS.substring(0, startIndex));
            } else if (startIndex == tmpIndex4) {
                this.inXmlDef = true;
            } else {
                if (this.changeBase) {
                    this.toFindHtmlSB = new StringBuffer();
                }
                this.inTag = true;
            }
        }
        this.doNext(targetS, startIndex);
    }

    private void doNext(String targetS, int _index) {
        this.doNext(targetS, _index, false, false);
    }

    private void doNext(String targetS, int _index, boolean insertId, boolean endWithSlash) {
        if (_index > -1) {
            int index = _index + 1;
            this.column += index;
            if (insertId) {
                if (endWithSlash) {
                    this.resultSB.append(String.valueOf(targetS.substring(0, _index - 1)) + " " + "eclipse-actf-id" + "='" + this.id + "'/>");
                } else {
                    this.resultSB.append(String.valueOf(targetS.substring(0, _index)) + " " + "eclipse-actf-id" + "='" + this.id + "'>");
                }
                ++this.id;
            } else if (!this.inScript) {
                this.resultSB.append(targetS.substring(0, index));
            }
            if (this.insertBaseNow) {
                this.resultSB.append("<HEAD><BASE href=\"" + this.baseUrl + "\"></HEAD>");
                this.insertBaseNow = false;
            }
            this.currentTargetString = targetS.substring(index);
        } else {
            if (!this.inScript) {
                this.resultSB.append(String.valueOf(targetS) + FileUtils.LINE_SEP);
            }
            this.currentTargetString = null;
        }
    }
}

