/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.AccessibleObjectFactory;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.TargetWindow;
import org.eclipse.actf.visualization.gui.ui.views.IFlashDOMView;
import org.eclipse.actf.visualization.gui.ui.views.IJAWSTextView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAListView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAProblemsView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAPropertiesView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.views.properties.PropertySheet;

public class MSAAViewRegistory
implements IGuiViewIDs {
    public static AccessibleObject rootObject = null;
    public static AccessibleObject outlineObject = null;
    private static int updateRef = 0;
    private static final Display display = Display.getCurrent();
    private static int hwndRoot = 0;
    private static IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            int hwnd;
            if (partRef instanceof IEditorReference && TargetWindow.isEmbeddedBrowser() && (hwnd = TargetWindow.getRootWindow()) != hwndRoot) {
                display.timerExec("Web Browser".equals(partRef.getPartName()) ? 3000 : 0, new Runnable(){

                    public void run() {
                        if (!display.isDisposed() && hwnd != hwndRoot) {
                            MSAAViewRegistory.refreshRootObject();
                        }
                    }
                });
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    };
    private static boolean partListening = false;

    public static void outlineSelected(Object object) {
        MSAAViewRegistory.addUpdateRef();
        try {
            object = MSAAViewRegistory.adjustSelection(object);
            if (object instanceof AccessibleObject) {
                IJAWSTextView jawsTextView;
                outlineObject = (AccessibleObject)object;
                MSAAViewRegistory.showProperties(outlineObject);
                IMSAAListView listView = (IMSAAListView)MSAAViewRegistory.findView(ID_SIBLINGSVIEW);
                if (listView != null) {
                    listView.setSelection(outlineObject);
                }
                if ((jawsTextView = (IJAWSTextView)MSAAViewRegistory.findView(ID_SUMMARYVIEW)) != null) {
                    jawsTextView.setSelection(outlineObject);
                }
                HighlightComposite.flashRectangle((Rectangle)outlineObject.getAccLocation());
            }
        }
        finally {
            MSAAViewRegistory.releaseUpdateRef();
        }
    }

    public static boolean showProperties(Object input) {
        IViewPart propertySheet;
        boolean rc = false;
        IMSAAPropertiesView propertiesView = (IMSAAPropertiesView)MSAAViewRegistory.findView(ID_PROPERTIESVIEW);
        if (propertiesView != null) {
            propertiesView.setInput(input);
            rc = true;
        }
        if ((propertySheet = MSAAViewRegistory.findView("org.eclipse.ui.views.PropertySheet")) instanceof PropertySheet) {
            ((PropertySheet)propertySheet).selectionChanged(null, (ISelection)new StructuredSelection(input));
            rc = true;
        }
        return rc;
    }

    public static IViewReference findViewReference(String viewId) {
        try {
            IWorkbenchPage page = PlatformUIUtil.getActivePage();
            if (page != null) {
                return page.findViewReference(viewId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IViewPart findView(String viewId) {
        try {
            IViewReference ref = MSAAViewRegistory.findViewReference(viewId);
            if (ref != null) {
                return ref.getView(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IViewPart showView(String viewId, boolean activate) {
        try {
            IWorkbenchPage page = PlatformUIUtil.getActivePage();
            if (page != null) {
                IViewPart part = page.findView(viewId);
                if (part != null) {
                    if (activate) {
                        page.activate((IWorkbenchPart)part);
                    }
                    return part;
                }
                return page.showView(viewId, null, activate ? 1 : 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void hideView(String viewId) {
        try {
            IViewPart part;
            IWorkbenchPage page = PlatformUIUtil.getActivePage();
            if (page != null && (part = page.findView(viewId)) != null) {
                page.hideView(part);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static AccessibleObject getRootObject() {
        if (rootObject == null && (hwndRoot = TargetWindow.getRootWindow()) != 0) {
            rootObject = AccessibleObjectFactory.getAccessibleObjectFromWindow(hwndRoot);
        }
        if (!partListening) {
            IWorkbenchPage activePage = PlatformUIUtil.getActivePage();
            activePage.addPartListener(partListener);
            partListening = true;
        }
        return rootObject;
    }

    public static void refreshRootObject() {
        MSAAViewRegistory.addUpdateRef();
        HighlightComposite.updateSuppressCount((int)1);
        try {
            IJAWSTextView jawsTextView;
            IMSAAProblemsView problemsView;
            IFlashDOMView flashDOMView;
            IMSAAOutlineView outlineView;
            if (rootObject != null) {
                rootObject.reset();
                rootObject = null;
            }
            if ((outlineView = (IMSAAOutlineView)MSAAViewRegistory.findView(ID_OUTLINEVIEW)) != null) {
                outlineView.refresh();
            }
            if ((flashDOMView = (IFlashDOMView)MSAAViewRegistory.findView("org.eclipse.actf.visualization.flash.ui.views.FlashDOMView")) != null) {
                flashDOMView.refresh();
            }
            if ((problemsView = (IMSAAProblemsView)MSAAViewRegistory.findView(ID_REPORTVIEW)) != null) {
                problemsView.refresh();
            }
            if ((jawsTextView = (IJAWSTextView)MSAAViewRegistory.findView(ID_SUMMARYVIEW)) != null) {
                jawsTextView.refresh();
            }
            MSAAViewRegistory.outlineSelected(null);
        }
        finally {
            HighlightComposite.updateSuppressCount((int)-1);
            MSAAViewRegistory.releaseUpdateRef();
        }
    }

    public static AccessibleObject adjustSelection(Object selection) {
        AccessibleObject[] rootChildlen;
        MSAAViewRegistory.getRootObject();
        if (selection instanceof AccessibleObject && selection != rootObject) {
            return (AccessibleObject)selection;
        }
        if (rootObject != null && (rootChildlen = rootObject.getChildren()) != null && rootChildlen.length > 0) {
            return rootChildlen[0];
        }
        return rootObject;
    }

    public static int addUpdateRef() {
        return ++updateRef;
    }

    public static int releaseUpdateRef() {
        return --updateRef;
    }

    public static int getUpdateRef() {
        return updateRef;
    }
}

