/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleHypertext;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleHypertext;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.InternalAccessibleHyperlink;
import org.eclipse.actf.util.win32.NativeIntAccess;

public class InternalAccessibleHypertext
implements AccessibleHypertext {
    private IAccessibleHypertext accessibleHypertext = null;

    public InternalAccessibleHypertext(int address) {
        this.accessibleHypertext = new IAccessibleHypertext(address);
        this.accessibleHypertext.AddRef();
    }

    public void dispose() {
        if (this.accessibleHypertext != null) {
            this.accessibleHypertext.Release();
            this.accessibleHypertext = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public int getHyperLinkCount() {
        if (this.accessibleHypertext != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleHypertext.get_nHyperlinks(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public InternalAccessibleHyperlink getHyperLink(int index) {
        if (this.accessibleHypertext != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleHypertext.get_hyperlink(index, nia.getAddress()) == 0) {
                    InternalAccessibleHyperlink internalAccessibleHyperlink = new InternalAccessibleHyperlink(nia.getInt());
                    return internalAccessibleHyperlink;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int getHyperLinkIndex(int charIndex) {
        if (this.accessibleHypertext != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleHypertext.get_hyperlinkIndex(charIndex, nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return -1;
    }
}

