/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleHyperlink;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleHyperlink;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeVariantAccess;
import org.eclipse.swt.ole.win32.Variant;

public class InternalAccessibleHyperlink
implements AccessibleHyperlink {
    private IAccessibleHyperlink accessibleHyperlink = null;

    public InternalAccessibleHyperlink(int address) {
        this.accessibleHyperlink = new IAccessibleHyperlink(address);
        this.accessibleHyperlink.AddRef();
    }

    public void dispose() {
        if (this.accessibleHyperlink != null) {
            this.accessibleHyperlink.Release();
            this.accessibleHyperlink = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public Variant getAccessibleActionAnchor(int index) {
        if (this.accessibleHyperlink != null) {
            NativeVariantAccess nva = new NativeVariantAccess();
            try {
                if (this.accessibleHyperlink.get_anchor(index, nva.getAddress()) == 0) {
                    Variant variant = nva.getVariant();
                    return variant;
                }
            }
            finally {
                nva.dispose();
            }
        }
        return null;
    }

    public Variant getAccessibleActionObject(int index) {
        if (this.accessibleHyperlink != null) {
            NativeVariantAccess nva = new NativeVariantAccess();
            try {
                if (this.accessibleHyperlink.get_anchorTarget(index, nva.getAddress()) == 0) {
                    Variant variant = nva.getVariant();
                    return variant;
                }
            }
            finally {
                nva.dispose();
            }
        }
        return null;
    }

    public int getStartIndex() {
        if (this.accessibleHyperlink != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleHyperlink.get_startIndex(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return -1;
    }

    public int getEndIndex() {
        if (this.accessibleHyperlink != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleHyperlink.get_endIndex(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return -1;
    }

    public boolean isValid() {
        if (this.accessibleHyperlink != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleHyperlink.get_valid(nia.getAddress()) == 0) {
                    boolean bl = nia.getInt() != 0;
                    return bl;
                }
            }
            finally {
                nia.dispose();
            }
        }
        return false;
    }
}

